/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.util.config;

import com.HiWord9.RPRenames.RPRenames;
import com.HiWord9.RPRenames.util.rename.type.CITRename;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class PropertiesHelper {
    public static String getFirstName(String nbtDisplayName) {
        return PropertiesHelper.getFirstName(nbtDisplayName, null);
    }

    public static String getFirstName(String nbtDisplayName, @Nullable String path) {
        String name = PropertiesHelper.parseEscapes(nbtDisplayName);
        if (name.startsWith("pattern:") || name.startsWith("ipattern:")) {
            if (name.startsWith("i")) {
                name = name.substring(1);
            }
            name = name.replaceFirst("pattern:", "");
            name = name.replace("*", "");
            name = name.replace("?", "_");
        } else if (name.startsWith("regex:") || name.startsWith("iregex")) {
            if (name.startsWith("i")) {
                name = name.substring(1);
            }
            String originalRegex = name = name.replaceFirst("regex:", "");
            name = name.replace(".*", "");
            name = name.replace(".+", "_");
            try {
                Pattern.compile(originalRegex);
            }
            catch (PatternSyntaxException e) {
                RPRenames.LOGGER.error("\"{}\" is not a valid regex!{}", (Object)originalRegex, path != null ? " From: " + path : "");
                return name;
            }
            name = PropertiesHelper.solveRegex(name);
            try {
                if (!name.matches(originalRegex)) {
                    RPRenames.LOGGER.error("Couldn't get valid string from regex{}\nregex: \"{}\"\nreceived string: \"{}\"", new Object[]{path != null ? " from " + path : "", originalRegex, name});
                }
            }
            catch (PatternSyntaxException e) {
                RPRenames.LOGGER.error("Invalid regex \"{}\" in {}", (Object)originalRegex, (Object)path);
            }
        }
        return name;
    }

    public static String parseEscapes(String string) {
        char[] chars = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\\') {
                if (chars[i + 1] == 'u') {
                    char unicode;
                    String unicodeNumbers = string.substring(i + 2, i + 6);
                    try {
                        unicode = (char)Integer.parseInt(unicodeNumbers, 16);
                    }
                    catch (Exception e) {
                        stringBuilder.append(chars[i]);
                        RPRenames.LOGGER.warn("Invalid unicode \"{}\" for String: {}", (Object)unicodeNumbers, (Object)string);
                        continue;
                    }
                    i += 5;
                    stringBuilder.append(unicode);
                    continue;
                }
                if (chars[i + 1] == 'n') {
                    stringBuilder.append("\n");
                    continue;
                }
                if (chars[i + 1] == 'r') {
                    stringBuilder.append("\r");
                    continue;
                }
                if (chars[i + 1] == 'f') {
                    stringBuilder.append("\f");
                    continue;
                }
                if (chars[i + 1] == 't') {
                    stringBuilder.append("\t");
                    continue;
                }
                stringBuilder.append(chars[i]);
                continue;
            }
            stringBuilder.append(chars[i]);
        }
        return stringBuilder.toString();
    }

    public static String solveRegex(String string) {
        try {
            return PropertiesHelper.initialSolveRegex("(" + string + ")");
        }
        catch (Exception e) {
            RPRenames.LOGGER.error("Something went wrong on getting matching string for regex \"{}\"", (Object)string, (Object)e);
            return string;
        }
    }

    private static String initialSolveRegex(String string) {
        StringBuilder builder = new StringBuilder();
        char[] chars = string.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            StringBuilder builder2 = new StringBuilder();
            if (chars[i] == '[') {
                if (chars[i + 1] != '^') {
                    if (chars[i + 1] == '\\') {
                        ++i;
                    }
                    builder2.append(chars[i + 1]);
                    i += 2;
                    while (chars[i] != ']' || chars[i - 1] == '\\') {
                        ++i;
                    }
                } else {
                    if (chars[i + 2] == '\\') {
                        // empty if block
                    }
                    int start = ++i;
                    i += 3;
                    while (chars[i] != ']' || chars[i - 1] != '\\') {
                        ++i;
                    }
                    int ch = chars[start + 2];
                    int count = 0;
                    while (count != 65536 && !string.substring(start, i + 1).matches(String.valueOf((char)ch))) {
                        ++count;
                        if (++ch == 65536) {
                            ch = 0;
                        }
                        if (count != 65536) continue;
                        ch = 65535;
                    }
                    builder2.append((char)ch);
                }
            } else if (chars[i] == '(') {
                StringBuilder builder3 = new StringBuilder();
                int brackets = 0;
                ArrayList<Character> bracketsOrder = new ArrayList<Character>();
                while (i + 1 < chars.length) {
                    if (chars[++i - 1] == '\\') {
                        builder3.append(chars[i]);
                        continue;
                    }
                    if (chars[i] == '(') {
                        bracketsOrder.add(Character.valueOf('('));
                        ++brackets;
                    } else if (chars[i] == ')' && (bracketsOrder.isEmpty() || ((Character)bracketsOrder.getLast()).charValue() != '[')) {
                        if (brackets == 0) break;
                        bracketsOrder.add(Character.valueOf(')'));
                        --brackets;
                    } else if (chars[i] == '[') {
                        bracketsOrder.add(Character.valueOf('['));
                        ++brackets;
                    } else if (chars[i] == ']' && chars[i - 1] != '[') {
                        bracketsOrder.add(Character.valueOf(']'));
                        --brackets;
                    }
                    builder3.append(chars[i]);
                }
                if (!((builder3 = new StringBuilder(PropertiesHelper.initialSolveRegex(builder3.toString()))).toString().startsWith("|") || builder3.toString().endsWith("|") || builder3.toString().contains("||") || builder3.isEmpty())) {
                    for (int i1 = 0; i1 != builder3.length() && builder3.charAt(i1) != '|'; ++i1) {
                        builder2.append(builder3.charAt(i1));
                    }
                }
            } else if (chars[i] != '^' && chars[i] != '$') {
                if (chars[i] == '\\') {
                    ++i;
                }
                builder2.append(chars[i]);
            }
            if (i + 1 < chars.length && chars[i + 1] == '{') {
                int s;
                StringBuilder builder3 = new StringBuilder();
                i += 2;
                while (chars[i] != '}') {
                    builder3.append(chars[i]);
                    ++i;
                }
                int n = s = builder3.indexOf(",") == -1 ? builder3.length() : builder3.indexOf(",");
                if (s > 0 || s == builder3.length() - 1) {
                    builder.append(String.valueOf(builder2).repeat(Math.max(0, Integer.parseInt(builder3.substring(0, s)))));
                    continue;
                }
                if (s == 0) {
                    builder.append(String.valueOf(builder2).repeat(Math.max(0, Integer.parseInt(builder3.substring(s + 1)))));
                    continue;
                }
            } else if (!(i + 1 >= chars.length || chars[i + 1] != '*' && chars[i + 1] != '+' && chars[i + 1] != '?' || chars[++i] != '*' && chars[i] != '?')) continue;
            builder.append((CharSequence)builder2);
        }
        return builder.toString();
    }

    public static ArrayList<class_2561> parseCustomDescription(String description) {
        String[] split;
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        for (String s : split = description.replaceAll("\\\\&", String.valueOf('\u00a7')).split("\n")) {
            class_5250 line = class_2561.method_43473();
            char[] chars = s.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                class_5250 text = class_2561.method_43473();
                if (chars[i] == '\\' && i != chars.length - 1 && chars[i + 1] == '#' && i + 7 < chars.length) {
                    StringBuilder color = new StringBuilder();
                    for (int j = 2; j < 8; ++j) {
                        color.append(chars[i + j]);
                    }
                    if (color.toString().matches("[0-9a-fA-F]*")) {
                        text.method_27696(class_2583.field_24360.method_36139(Integer.parseInt(color.toString(), 16)));
                    } else {
                        text.method_27693("\\#" + String.valueOf(color));
                    }
                    i += 8;
                }
                StringBuilder stringBuilder = new StringBuilder();
                while (i < chars.length) {
                    if (chars[i] == '\\' && chars[i + 1] == '#') {
                        --i;
                        break;
                    }
                    stringBuilder.append(chars[i]);
                    ++i;
                }
                text.method_10852((class_2561)class_2561.method_43471((String)stringBuilder.toString()));
                line.method_10852((class_2561)text);
            }
            lines.add((class_2561)line);
        }
        return lines;
    }

    public static boolean matchesRange(int num, String list) {
        return PropertiesHelper.matchesRange(num, list, null);
    }

    public static boolean matchesRange(int num, String list, @Nullable class_1792 damagedItem) {
        if (list == null) {
            return true;
        }
        if (!(list.contains(" ") || list.contains("-") || list.contains("%"))) {
            try {
                return num == Integer.parseInt(PropertiesHelper.getFirstValueInList(list));
            }
            catch (Exception e) {
                RPRenames.LOGGER.error("Could not get valid Damage value from list: {}", (Object)list, (Object)e);
                return false;
            }
        }
        for (String s : PropertiesHelper.splitList(list)) {
            if (s.contains("-")) {
                if (s.indexOf("-") == s.length() - 1) {
                    CITRename.Damage minDamage;
                    String min = s.substring(0, s.length() - 1);
                    if (!(min.endsWith("%") ? num >= (minDamage = new CITRename.Damage(Integer.parseInt(min = min.substring(0, min.length() - 1)), true)).getParsedDamage(damagedItem) : num >= Integer.parseInt(min))) continue;
                    return true;
                }
                int i = s.indexOf(45);
                String min = s.substring(0, i);
                String max = s.substring(i + 1);
                if (max.endsWith("%")) {
                    max = max.replace("%", "");
                    CITRename.Damage minDamage = new CITRename.Damage(Integer.parseInt(min), true);
                    CITRename.Damage maxDamage = new CITRename.Damage(Integer.parseInt(max), true);
                    if (num < minDamage.getParsedDamage(damagedItem) || num > maxDamage.getParsedDamage(damagedItem)) continue;
                    return true;
                }
                if (num < Integer.parseInt(min) || num > Integer.parseInt(max)) continue;
                return true;
            }
            if (num != Integer.parseInt(s)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<String> splitList(String list) {
        ArrayList<String> split = new ArrayList<String>();
        if (list.contains(" ")) {
            int i1 = 0;
            for (int i = 0; i <= list.length(); ++i) {
                if (i != list.length() && list.charAt(i) != ' ') continue;
                split.add(list.substring(i1, i));
                i1 = i + 1;
            }
        } else {
            split.add(list);
        }
        return split;
    }

    public static int parseDamagePercent(int percent, class_1792 item) {
        Object maxDamageComponent = item.method_57347().method_57829(class_9334.field_50072);
        if (maxDamageComponent instanceof Integer) {
            Integer maxDamage = (Integer)maxDamageComponent;
            return maxDamage * percent / 100;
        }
        return 0;
    }

    public static String getFirstValueInList(String list) {
        StringBuilder builder = new StringBuilder();
        for (int n = 0; n < list.length() && list.charAt(n) != '-' && list.charAt(n) != ' '; ++n) {
            builder.append(list.charAt(n));
        }
        if (list.contains("%")) {
            builder.append("%");
        }
        return builder.toString();
    }

    public static String getCustomName(Properties properties) {
        return PropertiesHelper.getComponentOrLegacyProperty(properties, "custom_name", "nbt.display.Name");
    }

    public static String getComponentWithNamespaceProperty(Properties properties, String component) {
        String keyPattern = "components.~" + component;
        String value = properties.getProperty(keyPattern.replace("~", ""));
        if (value == null) {
            value = properties.getProperty(keyPattern.replace("~", "minecraft:"));
        }
        if (value == null) {
            value = properties.getProperty(keyPattern);
        }
        return value;
    }

    public static String getComponentOrLegacyProperty(Properties properties, String component, String legacy) {
        String value = PropertiesHelper.getComponentWithNamespaceProperty(properties, component);
        if (value == null) {
            value = properties.getProperty(legacy);
        }
        return value;
    }
}

