/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.util.config.favorite;

import com.HiWord9.RPRenames.RPRenames;
import com.HiWord9.RPRenames.util.config.generation.ParserHelper;
import com.HiWord9.RPRenames.util.rename.RenameSerializer;
import com.HiWord9.RPRenames.util.rename.type.AbstractRename;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1802;

public class FavoritesFileManager {
    Path configPathFavorite;

    public FavoritesFileManager(Path configPathFavorite) {
        this.configPathFavorite = configPathFavorite;
    }

    public Map<class_1792, ArrayList<AbstractRename>> getAllSavedFavorites() {
        HashMap<class_1792, ArrayList<AbstractRename>> favoriteRenames = new HashMap<class_1792, ArrayList<AbstractRename>>();
        File[] files = this.configPathFavorite.toFile().listFiles();
        if (files == null) {
            return favoriteRenames;
        }
        for (File file : files) {
            class_1792 item = FavoritesFileManager.itemFromFavoriteFileName(file.getName());
            favoriteRenames.put(item, this.savedFavorites(item));
        }
        return favoriteRenames;
    }

    public void setFavorites(ArrayList<AbstractRename> renames, class_1792 item) {
        if (!renames.isEmpty()) {
            this.writeFavoriteFile(renames, item);
        } else {
            this.deleteFavoriteConfigFile(item);
        }
    }

    public ArrayList<AbstractRename> savedFavorites(class_1792 item) {
        ArrayList<AbstractRename> renames = new ArrayList<AbstractRename>();
        File favoritesFile = new File(this.pathToFavoriteFile(item));
        if (favoritesFile.exists()) {
            renames = this.readFavoriteFile(favoritesFile);
            for (AbstractRename r : renames) {
                if (r.getItem() != null) continue;
                r.setItem(item);
            }
        }
        return renames;
    }

    private ArrayList<AbstractRename> readFavoriteFile(File file) {
        ArrayList renames = new ArrayList();
        try {
            FileReader fileReader = new FileReader(file);
            Type type = new TypeToken<ArrayList<AbstractRename>>(){}.getType();
            Gson gson = new GsonBuilder().registerTypeAdapter(AbstractRename.class, (Object)new RenameSerializer()).create();
            renames = (ArrayList)gson.fromJson((Reader)fileReader, type);
            fileReader.close();
        }
        catch (Exception e) {
            RPRenames.LOGGER.error("Could not read Favorites from file {}", (Object)file, (Object)e);
        }
        return renames;
    }

    private void writeFavoriteFile(ArrayList<AbstractRename> renames, class_1792 item) {
        try {
            File file;
            if (this.configPathFavorite.toFile().mkdirs()) {
                RPRenames.LOGGER.info("Created folder for favorites config: {}", (Object)this.configPathFavorite);
            }
            if (!(file = new File(this.pathToFavoriteFile(item))).exists()) {
                RPRenames.LOGGER.info("Creating new file for favorites config: {}", (Object)this.pathToFavoriteFile(item));
            }
            FileWriter fileWriter = new FileWriter(file);
            Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(AbstractRename.class, (Object)new RenameSerializer()).create();
            gson.toJson(renames, (Appendable)fileWriter);
            fileWriter.close();
        }
        catch (Exception e) {
            RPRenames.LOGGER.error("Could not write Favorites for {}", (Object)item, (Object)e);
        }
    }

    private void deleteFavoriteConfigFile(class_1792 item) {
        Path path = Path.of(this.pathToFavoriteFile(item), new String[0]);
        try {
            Files.deleteIfExists(path);
        }
        catch (Exception e) {
            RPRenames.LOGGER.error("Could not delete file for Favorites {}", (Object)path, (Object)e);
        }
    }

    protected void doomConfigs(ArrayList<class_1792> items) {
        items.forEach(this::deleteFavoriteConfigFile);
    }

    private static class_1792 itemFromFavoriteFileName(String fileName) {
        if (!fileName.endsWith(".json")) {
            return class_1802.field_8162;
        }
        String itemFromFileName = fileName.substring(0, fileName.length() - 5).replace(".", ":");
        return ParserHelper.itemFromName(itemFromFileName);
    }

    private String pathToFavoriteFile(class_1792 item) {
        return String.valueOf(this.configPathFavorite) + File.separator + FavoritesFileManager.fileNameFromItem(item);
    }

    private static String fileNameFromItem(class_1792 item) {
        return ParserHelper.idFromItem(item).replace(":", ".") + ".json";
    }
}

