/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.util.rename;

import com.HiWord9.RPRenames.RPRenames;
import com.HiWord9.RPRenames.modConfig.ModConfig;
import com.HiWord9.RPRenames.util.config.PropertiesHelper;
import com.HiWord9.RPRenames.util.config.favorite.FavoritesManager;
import com.HiWord9.RPRenames.util.config.generation.ParserHelper;
import com.HiWord9.RPRenames.util.rename.type.AbstractRename;
import com.HiWord9.RPRenames.util.rename.type.CEMRename;
import com.HiWord9.RPRenames.util.rename.type.CITRename;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_310;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class RenamesHelper {
    private static final ModConfig config = ModConfig.INSTANCE;

    public static class_1799[] getGhostCraftItems(AbstractRename rename) {
        class_1799 ghostSource = new class_1799((class_1935)rename.getItem());
        class_1799 ghostEnchant = class_1799.field_8037;
        class_1799 ghostResult = rename.toStack();
        if (rename instanceof CITRename) {
            CITRename citRename = (CITRename)rename;
            ghostSource.method_7939(citRename.getStackSize());
            if (citRename.getDamage() != null) {
                ghostSource.method_7974(citRename.getDamage().getParsedDamage(ghostSource.method_7909()));
            }
            ghostEnchant = RenamesHelper.getGhostCraftEnchant(citRename);
        }
        return new class_1799[]{ghostSource, ghostEnchant, ghostResult};
    }

    public static class_1799 getGhostCraftEnchant(CITRename rename) {
        class_1799 ghostEnchant = class_1799.field_8037;
        if (rename.getEnchantment() != null) {
            ghostEnchant = new class_1799((class_1935)class_1802.field_8598);
            RenamesHelper.enchantItemStackWithRename(rename, ghostEnchant);
        }
        return ghostEnchant;
    }

    public static void enchantItemStackWithRename(CITRename rename, class_1799 itemStack) {
        if (class_310.method_1551().field_1687 == null) {
            RPRenames.LOGGER.warn("Could not enchant item stack {} with rename\n{}\ncause client world is null", (Object)itemStack, (Object)rename);
            return;
        }
        Optional optionalEnchantment = class_310.method_1551().field_1687.method_30349().method_30530(class_7924.field_41265).method_55841(rename.getEnchantment());
        if (optionalEnchantment.isPresent()) {
            itemStack.method_7978((class_6880)optionalEnchantment.get(), rename.getEnchantmentLevel());
        } else {
            RPRenames.LOGGER.warn("Could not enchant item stack {} with rename\n{}\ncause enchantment {} is not loaded", new Object[]{itemStack, rename, rename.getEnchantment()});
        }
    }

    public static class_1799 createItemOrSpawnEgg(AbstractRename rename) {
        return RenamesHelper.createItemOrSpawnEgg(rename, 0);
    }

    public static class_1799 createItemOrSpawnEgg(AbstractRename rename, int itemIndex) {
        if (rename instanceof CEMRename) {
            CEMRename cemRename = (CEMRename)rename;
            if (RenamesHelper.config.generateSpawnEggsInItemGroup) {
                return cemRename.toSpawnEgg();
            }
        }
        return rename.toStack(itemIndex);
    }

    public static ArrayList<AbstractRename> search(ArrayList<AbstractRename> list, String match) {
        return RenamesHelper.search(list, match, RPRenames.favoritesManager);
    }

    public static ArrayList<AbstractRename> search(ArrayList<AbstractRename> list, String match, FavoritesManager favoritesManager) {
        ArrayList<AbstractRename> cutList;
        block42: {
            block40: {
                block41: {
                    cutList = new ArrayList<AbstractRename>();
                    if (!match.startsWith("#")) break block40;
                    String matchTag = match.substring(1);
                    if (matchTag.contains(" ") && !matchTag.toUpperCase(Locale.ROOT).contains("#REGEX:") && !matchTag.toUpperCase(Locale.ROOT).contains("#IREGEX:")) {
                        matchTag = matchTag.substring(0, matchTag.indexOf(" "));
                    } else if (matchTag.contains(" #")) {
                        matchTag = matchTag.substring(0, matchTag.indexOf(" #"));
                    }
                    if (matchTag.toUpperCase(Locale.ROOT).startsWith("REGEX:") || matchTag.toUpperCase(Locale.ROOT).startsWith("IREGEX:")) {
                        boolean isRegex;
                        String regex = matchTag;
                        boolean caseInsensitive = false;
                        if (matchTag.toUpperCase(Locale.ROOT).startsWith("I")) {
                            regex = regex.substring(1);
                            caseInsensitive = true;
                        }
                        regex = regex.substring(6);
                        try {
                            Pattern.compile(regex);
                            isRegex = true;
                        }
                        catch (PatternSyntaxException e) {
                            isRegex = false;
                        }
                        if (isRegex) {
                            for (AbstractRename r : list) {
                                if (!(caseInsensitive ? r.getName().toUpperCase(Locale.ROOT).matches(regex.toUpperCase(Locale.ROOT)) : r.getName().matches(regex))) continue;
                                cutList.add(r);
                            }
                        }
                    } else if (matchTag.toUpperCase(Locale.ROOT).startsWith("PACK:") || matchTag.toUpperCase(Locale.ROOT).startsWith("PACKNAME:")) {
                        String packName = matchTag.substring(4);
                        while (packName.charAt(0) != ':') {
                            packName = packName.substring(1);
                        }
                        packName = packName.substring(1);
                        for (AbstractRename r : list) {
                            if (r.getPackName() == null || !r.getPackName().replace(" ", "_").toUpperCase(Locale.ROOT).contains(packName.toUpperCase(Locale.ROOT))) continue;
                            cutList.add(r);
                        }
                    } else if (matchTag.toUpperCase(Locale.ROOT).startsWith("ITEM:")) {
                        String itemName = matchTag.substring(5);
                        block7: for (AbstractRename r : list) {
                            for (class_1792 item : r.getItems()) {
                                if (!ParserHelper.idFromItem(item).toUpperCase(Locale.ROOT).contains(itemName.toUpperCase(Locale.ROOT))) continue;
                                cutList.add(r);
                                continue block7;
                            }
                        }
                    } else if (matchTag.toUpperCase(Locale.ROOT).startsWith("STACKSIZE:") || matchTag.toUpperCase(Locale.ROOT).startsWith("STACK:") || matchTag.toUpperCase(Locale.ROOT).startsWith("SIZE:")) {
                        String stackSize = matchTag.toUpperCase(Locale.ROOT).substring(4);
                        while (stackSize.charAt(0) != ':') {
                            stackSize = stackSize.substring(1);
                        }
                        if ((stackSize = stackSize.substring(1)).matches("[0-9]+")) {
                            for (AbstractRename r : list) {
                                if (!(r instanceof CITRename)) continue;
                                CITRename citRename = (CITRename)r;
                                if (!PropertiesHelper.matchesRange(Integer.parseInt(stackSize), citRename.getOriginalStackSize())) continue;
                                cutList.add(r);
                            }
                        }
                    } else if (matchTag.toUpperCase(Locale.ROOT).startsWith("DAMAGE:")) {
                        String damage = matchTag.substring(7);
                        if (damage.matches("[0-9]{1,9}")) {
                            block11: for (AbstractRename r : list) {
                                if (!(r instanceof CITRename)) continue;
                                CITRename citRename = (CITRename)r;
                                for (class_1792 item : citRename.getItems()) {
                                    if (!PropertiesHelper.matchesRange(Integer.parseInt(damage), citRename.getOriginalDamage(), item)) continue;
                                    cutList.add(r);
                                    continue block11;
                                }
                            }
                        }
                    } else if (matchTag.toUpperCase(Locale.ROOT).startsWith("ENCH:") || matchTag.toUpperCase(Locale.ROOT).startsWith("ENCHANT:") || matchTag.toUpperCase(Locale.ROOT).startsWith("ENCHANTMENT:")) {
                        String enchant = matchTag.toUpperCase(Locale.ROOT).substring(4);
                        while (enchant.charAt(0) != ':') {
                            enchant = enchant.substring(1);
                        }
                        enchant = enchant.substring(1);
                        block14: for (AbstractRename r : list) {
                            CITRename citRename;
                            if (!(r instanceof CITRename) || (citRename = (CITRename)r).getEnchantment() == null) continue;
                            ArrayList<String> split = PropertiesHelper.splitList(citRename.getOriginalEnchantment());
                            for (String s : split) {
                                if (!s.toUpperCase(Locale.ROOT).contains(enchant)) continue;
                                cutList.add(r);
                                continue block14;
                            }
                        }
                    } else if (matchTag.toUpperCase(Locale.ROOT).startsWith("FAV:") || matchTag.toUpperCase(Locale.ROOT).startsWith("FAVORITE:")) {
                        block16: for (AbstractRename r : list) {
                            for (class_1792 item : r.getItems()) {
                                if (!favoritesManager.isFavorite(item, r.getName())) continue;
                                cutList.add(r);
                                continue block16;
                            }
                        }
                    }
                    if (!match.substring(1).contains(" ") || matchTag.toUpperCase(Locale.ROOT).contains("#REGEX:") || matchTag.toUpperCase(Locale.ROOT).contains("#IREGEX:")) break block41;
                    cutList = RenamesHelper.search(cutList, match.substring(match.indexOf(" ") + 1), favoritesManager);
                    break block42;
                }
                if (!match.substring(1).contains(" #")) break block42;
                cutList = RenamesHelper.search(cutList, match.substring(match.indexOf(" #") + 1), favoritesManager);
                break block42;
            }
            if (match.startsWith("\\#")) {
                match = match.substring(1);
            }
            boolean isRegex = false;
            try {
                Pattern.compile(match);
                isRegex = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (AbstractRename r : list) {
                if (!r.getName().toUpperCase(Locale.ROOT).contains(match.toUpperCase(Locale.ROOT)) && (!isRegex || !r.getName().toUpperCase(Locale.ROOT).matches(match.toUpperCase(Locale.ROOT)))) continue;
                cutList.add(r);
            }
        }
        return cutList;
    }
}

