/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.util.rename.type;

import com.HiWord9.RPRenames.util.gui.widget.RPRWidget;
import com.HiWord9.RPRenames.util.rename.renderer.DefaultRenameRenderer;
import com.HiWord9.RPRenames.util.rename.renderer.RenameRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_9334;

public class AbstractRename {
    String name;
    String packName;
    String path;
    Properties properties;
    ArrayList<class_1792> items = new ArrayList();

    public AbstractRename(String name) {
        this(name, null);
    }

    public AbstractRename(String name, class_1792 item) {
        this(name, null, null, null, item);
    }

    public AbstractRename(String name, String packName, String path, Properties properties, class_1792 item) {
        this(name, packName, path, properties, item == null ? null : new ArrayList<class_1792>(List.of(item)));
    }

    public AbstractRename(String name, String packName, String path, Properties properties, ArrayList<class_1792> items) {
        this.name = name;
        this.packName = packName;
        this.path = path == null ? null : path.replace("\\", "/");
        this.properties = properties;
        this.setItems(items);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackName() {
        return this.packName;
    }

    public void setPackName(String packName) {
        this.packName = packName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ArrayList<class_1792> getItems() {
        return this.items;
    }

    public void setItems(ArrayList<class_1792> items) {
        if (items == null) {
            this.items = new ArrayList();
            return;
        }
        this.items = items;
    }

    public class_1792 getItem() {
        return this.items.isEmpty() ? null : this.items.getFirst();
    }

    public void setItem(class_1792 item) {
        if (this.items == null || this.items.isEmpty()) {
            this.items = new ArrayList();
            this.items.add(item);
        } else {
            this.items.set(0, item);
        }
    }

    public String getNamePattern() {
        return null;
    }

    public class_1799 toStack() {
        return this.toStack(0);
    }

    public class_1799 toStack(int index) {
        class_1799 stack = new class_1799((class_1935)this.items.get(index));
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)this.name));
        return stack;
    }

    public RenameRenderer getNewRenderer(RPRWidget rprWidget, boolean favorite) {
        return new DefaultRenameRenderer<AbstractRename>(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractRename) {
            AbstractRename abstractRename = (AbstractRename)obj;
            return this.equals(abstractRename);
        }
        return false;
    }

    public boolean equals(AbstractRename obj) {
        return this.equals(obj, false);
    }

    public boolean equals(AbstractRename obj, boolean ignoreNull) {
        return this.same(obj, ignoreNull) && AbstractRename.paramsEquals(this.packName, obj.packName, ignoreNull) && AbstractRename.paramsEquals(this.path, obj.path, ignoreNull) && AbstractRename.paramsEquals(this.properties, obj.properties, ignoreNull);
    }

    public boolean same(AbstractRename obj, boolean ignoreNull) {
        return AbstractRename.paramsEquals(this.name, obj.name, ignoreNull) && AbstractRename.paramsEquals(this.getItem(), obj.getItem(), ignoreNull);
    }

    protected static boolean paramsEquals(Object obj1, Object obj2, boolean ignoreNull) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return ignoreNull;
        }
        return obj1.equals(obj2);
    }

    public boolean isContainedIn(ArrayList<AbstractRename> list) {
        return this.isContainedIn(list, false);
    }

    public boolean isContainedIn(ArrayList<AbstractRename> list, boolean ignoreNull) {
        return this.indexIn(list, ignoreNull) != -1;
    }

    public int indexIn(ArrayList<AbstractRename> list, boolean ignoreNull) {
        int i = -1;
        if (list == null) {
            return i;
        }
        for (AbstractRename r : list) {
            ++i;
            if (!r.equals(this, ignoreNull)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.getClass().getName() + "{name='" + this.name + "', packName='" + this.packName + "', path='" + this.path + "', properties=" + String.valueOf(this.properties) + ", items=" + String.valueOf(this.items) + "}";
    }
}

