/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2246;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.particle.BlockDustParticle2D;
import su.plo.lib.mod.client.render.pipeline.RenderPipelines;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.util.RandomUtil;

public final class VoiceSettingsAboutFeature {
    private final VoiceSettingsScreen parent;
    private final List<BlockDustParticle2D> particles = Lists.newArrayList();
    private int clickCount;
    private long lastClick;

    public void tick() {
        this.particles.removeAll(this.particles.stream().filter(particle -> {
            particle.tick();
            return !particle.isAlive();
        }).collect(Collectors.toList()));
        if (System.currentTimeMillis() - this.lastClick > 5000L) {
            this.clickCount = 0;
        }
    }

    public void titleClicked() {
        if (this.clickCount > 10) {
            this.parent.getNavigation().openTab(-1);
            this.lastClick = 0L;
            this.clickCount = 0;
            class_1144 soundManager = class_310.method_1551().method_1483();
            soundManager.method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_15015.comp_349()), (float)1.0f, (float)0.25f));
            return;
        }
        this.lastClick = System.currentTimeMillis();
        ++this.clickCount;
        class_1144 soundManager = class_310.method_1551().method_1483();
        soundManager.method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14697, (float)1.0f, (float)1.0f));
        for (int i = 0; i < 2 + RandomUtil.randomInt(3); ++i) {
            BlockDustParticle2D particle = new BlockDustParticle2D(14 + RandomUtil.randomInt(this.parent.getTitleWidth()), 15 + RandomUtil.randomInt(RenderUtil.getFontHeight()), 0.0, 0.0, class_2246.field_10566.method_9564());
            particle.setMaxAge(10 + RandomUtil.randomInt(25));
            particle.setVelocity(RandomUtil.randomFloat(-0.25f, 0.25f), -0.25);
            particle.setGravityStrength(4.0f);
            particle.setScale(RandomUtil.randomFloat(1.5f, 2.5f));
            this.particles.add(particle);
        }
    }

    public void render(@NotNull class_4587 stack, float delta) {
        for (BlockDustParticle2D particle : this.particles) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.bindTexture(0, particle.getSprite().method_45852());
            class_287 buffer = RenderUtil.beginBuffer(RenderPipelines.GUI_PARTICLE_TEXTURE_COLOR);
            particle.buildGeometry(stack, buffer, delta);
            RenderUtil.drawBuffer(buffer, RenderPipelines.GUI_PARTICLE_TEXTURE_COLOR);
        }
    }

    public VoiceSettingsAboutFeature(VoiceSettingsScreen parent) {
        this.parent = parent;
    }
}

