/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.lib.mod.client.gui.components.AbstractSlider;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.gui.components.IconButton;
import su.plo.lib.mod.client.gui.widget.GuiWidgetTexture;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.api.client.audio.capture.AudioCapture;
import su.plo.voice.api.client.audio.device.AudioDevice;
import su.plo.voice.api.client.audio.device.DeviceManager;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.util.AudioUtil;
import su.plo.voice.client.event.gui.MicrophoneTestStartedEvent;
import su.plo.voice.client.event.gui.MicrophoneTestStoppedEvent;
import su.plo.voice.client.gui.settings.MicrophoneTestController;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.widget.UpdatableWidget;

public final class ActivationThresholdWidget
extends AbstractSlider
implements UpdatableWidget {
    private static final class_2960 STOP_ICON = class_2960.method_12829((String)"plasmovoice:textures/icons/speaker_menu.png");
    private static final class_2960 START_ICON = class_2960.method_12829((String)"plasmovoice:textures/icons/speaker_menu_disabled.png");
    private static final McTextComponent NOT_AVAILABLE = McTextComponent.translatable("gui.plasmovoice.devices.not_available", new Object[0]);
    private final DoubleConfigEntry entry;
    private final MicrophoneTestController controller;
    private final List<Button> microphoneTest;

    public ActivationThresholdWidget(@NotNull VoiceSettingsScreen parent, @NotNull DoubleConfigEntry entry, @NotNull AudioCapture audioCapture, @NotNull DeviceManager devices, @NotNull MicrophoneTestController controller, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.entry = entry;
        this.controller = controller;
        IconButton testStop = new IconButton(0, 8, 20, 20, button -> controller.stop(), Button.NO_TOOLTIP, STOP_ICON, true);
        IconButton testStart = new IconButton(0, 20, 20, 20, button -> controller.start(), (button, matrices, mouseX, mouseY) -> {
            if (!button.isActive()) {
                parent.setTooltip(NOT_AVAILABLE);
            }
        }, START_ICON, true);
        testStop.setVisible(controller.isActive());
        testStart.setVisible(!controller.isActive());
        testStart.setActive(audioCapture.getDevice().map(AudioDevice::isOpen).orElse(false) != false && devices.getOutputDevice().isPresent());
        this.microphoneTest = ImmutableList.of((Object)testStop, (Object)testStart);
        this.updateValue();
    }

    @Override
    protected void updateText() {
        this.text = McTextComponent.literal(String.format("%.0f dB", AudioUtil.doubleRangeToAudioLevel(this.value)));
    }

    @Override
    protected void applyValue() {
        this.entry.set(AudioUtil.doubleRangeToAudioLevel(this.value));
    }

    @Override
    public void updateValue() {
        this.value = AudioUtil.audioLevelToDoubleRange((Double)this.entry.value());
        this.updateText();
    }

    @Override
    public boolean isHoveredOrFocused() {
        return super.isHoveredOrFocused() && this.active;
    }

    @Override
    public void renderButton(@NotNull class_4587 stack, int mouseX, int mouseY, float delta) {
        this.renderBackground(stack, mouseX, mouseY);
        this.renderMicrophoneValue(stack, this.getSliderWidth(), delta);
        this.renderTrack(stack, mouseX, mouseY);
        this.renderText(stack, mouseX, mouseY);
    }

    public List<Button> getButtons() {
        return this.microphoneTest;
    }

    private void renderMicrophoneValue(@NotNull class_4587 stack, int sliderWidth, float delta) {
        if (this.controller.getMicrophoneValue() > 0.95) {
            RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)this.alpha);
        } else if (this.controller.getMicrophoneValue() > 0.7) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)0.0f, (float)this.alpha);
        } else {
            RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)this.alpha);
        }
        GuiWidgetTexture sprite = GuiWidgetTexture.SLIDER;
        RenderUtil.bindTexture(0, sprite.getLocation());
        RenderUtil.blitSprite(stack, sprite, this.x + 1, this.y + 1, 1, 1, (int)((double)(sliderWidth - 2) * this.controller.getMicrophoneValue()), this.height - 2);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.controller.tick(delta);
    }

    @EventSubscribe
    public void onTestStarted(@NotNull MicrophoneTestStartedEvent event) {
        this.microphoneTest.get(0).setVisible(true);
        this.microphoneTest.get(1).setVisible(false);
    }

    @EventSubscribe
    public void onTestStopped(@NotNull MicrophoneTestStoppedEvent event) {
        this.microphoneTest.get(0).setVisible(false);
        this.microphoneTest.get(1).setVisible(true);
    }
}

