/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.gui.narration.NarrationOutput;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidgetTexture;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.VertexBuilder;
import su.plo.lib.mod.client.render.pipeline.RenderPipelines;
import su.plo.slib.api.chat.component.McTextComponent;

public class TextFieldWidget
extends GuiAbstractWidget {
    @Nullable
    private Consumer<String> responder;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, McTextComponent> formatter = (string, integer) -> McTextComponent.literal(string);
    private String value = "";
    private int maxLength = 32;
    private int frame;
    private boolean editable = true;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean shiftPressed;
    private int displayPosition;
    private int cursorPosition;
    private int highlightPosition;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    @Nullable
    private String suggestion;

    public TextFieldWidget(int x, int y, int width, int height, @NotNull McTextComponent text) {
        super(x, y, width, height, text);
    }

    @Override
    public void updateNarration(@NotNull NarrationOutput narrationOutput) {
        narrationOutput.add(NarrationOutput.Type.TITLE, McTextComponent.translatable("narration.edit_box", this.getValue()));
    }

    @Override
    public boolean keyPressed(int keyCode, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.shiftPressed = class_437.method_25442();
        if (class_437.method_25439((int)keyCode)) {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            if (this.isEditable()) {
                this.insertText(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            if (this.isEditable()) {
                this.insertText("");
            }
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.isEditable()) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.isEditable()) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.moveCursorTo(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 263: {
                if (class_437.method_25441()) {
                    this.moveCursorTo(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 268: {
                this.moveCursorToStart();
                return true;
            }
            case 269: 
        }
        this.moveCursorToEnd();
        return true;
    }

    @Override
    public boolean charTyped(char typedChar, int modifiers) {
        if (!this.canConsumeInput() || !TextFieldWidget.isAllowedChatCharacter(typedChar)) {
            return false;
        }
        if (this.isEditable()) {
            this.insertText(Character.toString(typedChar));
        }
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isVisible()) {
            return false;
        }
        boolean mouseOver = this.isMouseOver(mouseX, mouseY);
        if (this.canLoseFocus) {
            this.setFocused(mouseOver);
        }
        if (this.isFocused() && mouseOver && this.isValidClickButton(button)) {
            int j = class_3532.method_15357((double)mouseX) - this.x;
            if (this.bordered) {
                j -= 4;
            }
            String string = RenderUtil.stringToWidth(this.value.substring(this.displayPosition), this.getInnerWidth());
            this.moveCursorTo(RenderUtil.stringToWidth(string, j).length() + this.displayPosition);
            return true;
        }
        return false;
    }

    @Override
    public boolean changeFocus(boolean lookForwards) {
        return this.visible && this.isEditable() && super.changeFocus(lookForwards);
    }

    @Override
    protected void onFocusedChanged(boolean focused) {
        if (focused) {
            this.frame = 0;
        }
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.visible && super.isMouseOver(mouseX, mouseY);
    }

    @Override
    public void renderButton(@NotNull class_4587 stack, int mouseX, int mouseY, float delta) {
        int var10004;
        int var10003;
        int var10002;
        int color;
        if (!this.isVisible()) {
            return;
        }
        if (this.isBordered()) {
            color = this.isFocused() ? -1 : -6250336;
            GuiWidgetTexture sprite = this.isFocused() ? GuiWidgetTexture.TEXT_FIELD_ACTIVE : GuiWidgetTexture.TEXT_FIELD;
            RenderUtil.bindTexture(0, sprite.getLocation());
            RenderUtil.blitSprite(stack, sprite, this.x, this.y, 0, 0, this.width / 2, this.height);
            RenderUtil.blitSprite(stack, sprite, this.x + this.width / 2, this.y, sprite.getSpriteWidth() - this.width / 2, 0, this.width / 2, this.height);
        }
        color = this.isEditable() ? this.textColor : this.textColorUneditable;
        int l = this.cursorPosition - this.displayPosition;
        int m = this.highlightPosition - this.displayPosition;
        String string = RenderUtil.stringToWidth(this.value.substring(this.displayPosition), this.getInnerWidth());
        boolean bl = l >= 0 && l <= string.length();
        boolean bl2 = this.isFocused() && this.frame / 6 % 2 == 0 && bl;
        int n = this.bordered ? this.x + 5 : this.x;
        int o = this.bordered ? this.y + (this.height - 8) / 2 : this.y;
        int p = n;
        if (m > string.length()) {
            m = string.length();
        }
        if (!string.isEmpty()) {
            String string2 = bl ? string.substring(0, l) : string;
            p = RenderUtil.drawString(stack, this.formatter.apply(string2, this.displayPosition), n, o, color);
        }
        boolean bl3 = this.cursorPosition < this.value.length() || this.value.length() >= this.maxLength;
        int q = p;
        if (!bl) {
            q = l > 0 ? n + this.width : n;
        } else if (bl3) {
            q = p - 1;
            --p;
        }
        if (!string.isEmpty() && bl && l < string.length()) {
            RenderUtil.drawString(stack, this.formatter.apply(string.substring(l), this.cursorPosition), p, o, color);
        }
        if (!bl3 && this.suggestion != null) {
            RenderUtil.drawString(stack, this.suggestion, q - 1, o, -8355712);
        }
        if (string.isEmpty() && !this.isFocused()) {
            RenderUtil.drawString(stack, this.getText(), n, o, -1);
        }
        if (bl2) {
            if (bl3) {
                var10002 = o - 1;
                var10003 = q + 1;
                var10004 = o + 1;
                RenderUtil.fill(stack, q, var10002, var10003, var10004 + 9, -3092272);
            } else {
                RenderUtil.drawString(stack, "_", q, o, color);
            }
        }
        if (m != l) {
            int r = n + RenderUtil.getStringWidth(string.substring(0, m));
            var10002 = o - 1;
            var10003 = r - 1;
            var10004 = o + 1;
            this.renderHighlight(stack, q, var10002, var10003, var10004 + 9);
        }
    }

    private void renderHighlight(@NotNull class_4587 stack, int i, int j, int k, int l) {
        int m;
        if (i < k) {
            m = i;
            i = k;
            k = m;
        }
        if (j < l) {
            m = j;
            j = l;
            l = m;
        }
        if (k > this.x + this.width) {
            k = this.x + this.width;
        }
        if (i > this.x + this.width) {
            i = this.x + this.width;
        }
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        class_287 buffer = RenderUtil.beginBuffer(RenderPipelines.GUI_HIGHLIGHT);
        VertexBuilder.create(buffer).position(stack, i, l, 0.0f).end();
        VertexBuilder.create(buffer).position(stack, k, l, 0.0f).end();
        VertexBuilder.create(buffer).position(stack, k, j, 0.0f).end();
        VertexBuilder.create(buffer).position(stack, i, j, 0.0f).end();
        RenderUtil.drawBuffer(buffer, RenderPipelines.GUI_HIGHLIGHT);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean canConsumeInput() {
        return this.isVisible() && this.isFocused() && this.isEditable();
    }

    public void tick() {
        ++this.frame;
    }

    public void setValue(String value) {
        if (!this.filter.test(value)) {
            return;
        }
        this.value = value.length() > this.maxLength ? value.substring(0, this.maxLength) : value;
        this.moveCursorToEnd();
        this.setHighlightPos(this.cursorPosition);
        this.onValueChange(value);
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.value.length() > maxLength) {
            this.value = this.value.substring(0, maxLength);
            this.onValueChange(this.value);
        }
    }

    public String getHighlighted() {
        int start2 = Math.min(this.cursorPosition, this.highlightPosition);
        int end = Math.max(this.cursorPosition, this.highlightPosition);
        return this.value.substring(start2, end);
    }

    public void insertText(String string) {
        String string3;
        String string2;
        int l;
        int i = Math.min(this.cursorPosition, this.highlightPosition);
        int j = Math.max(this.cursorPosition, this.highlightPosition);
        int k = this.maxLength - this.value.length() - (i - j);
        if (k < (l = (string2 = TextFieldWidget.filterText(string)).length())) {
            string2 = string2.substring(0, k);
            l = k;
        }
        if (this.filter.test(string3 = new StringBuilder(this.value).replace(i, j, string2).toString())) {
            this.value = string3;
            this.setCursorPosition(i + l);
            this.setHighlightPos(this.cursorPosition);
            this.onValueChange(this.value);
        }
    }

    private void deleteText(int position) {
        if (class_437.method_25441()) {
            this.deleteWords(position);
        } else {
            this.deleteChars(position);
        }
    }

    public void deleteWords(int position) {
        if (!this.value.isEmpty()) {
            if (this.highlightPosition != this.cursorPosition) {
                this.insertText("");
            } else {
                this.deleteChars(this.getWordPosition(position) - this.cursorPosition);
            }
        }
    }

    public void deleteChars(int i) {
        if (!this.value.isEmpty()) {
            if (this.highlightPosition != this.cursorPosition) {
                this.insertText("");
            } else {
                String string;
                int l;
                int j = this.getCursorPos(i);
                int k = Math.min(j, this.cursorPosition);
                if (k != (l = Math.max(j, this.cursorPosition)) && this.filter.test(string = new StringBuilder(this.value).delete(k, l).toString())) {
                    this.value = string;
                    this.moveCursorTo(k);
                }
            }
        }
    }

    public int getWordPosition(int position) {
        return this.getWordPosition(position, this.cursorPosition);
    }

    private int getWordPosition(int position, int cursorPosition) {
        return this.getWordPosition(position, cursorPosition, true);
    }

    private int getWordPosition(int i, int j, boolean bl) {
        int k = j;
        boolean bl2 = i < 0;
        int l = Math.abs(i);
        for (int m = 0; m < l; ++m) {
            if (!bl2) {
                int n = this.value.length();
                if ((k = this.value.indexOf(32, k)) == -1) {
                    k = n;
                    continue;
                }
                while (bl && k < n && this.value.charAt(k) == ' ') {
                    ++k;
                }
                continue;
            }
            while (bl && k > 0 && this.value.charAt(k - 1) == ' ') {
                --k;
            }
            while (k > 0 && this.value.charAt(k - 1) != ' ') {
                --k;
            }
        }
        return k;
    }

    public void setCursorPosition(int position) {
        this.cursorPosition = class_3532.method_15340((int)position, (int)0, (int)this.value.length());
    }

    public void moveCursor(int position) {
        this.moveCursorTo(this.getCursorPos(position));
    }

    private int getCursorPos(int position) {
        return TextFieldWidget.offsetByCodepoints(this.value, this.cursorPosition, position);
    }

    public int getInnerWidth() {
        return this.isBordered() ? this.width - 8 : this.width;
    }

    public int getScreenX(int x) {
        return x > this.value.length() ? this.x : this.x + RenderUtil.getStringWidth(this.value.substring(0, x));
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    public void setHighlightPos(int position) {
        int valueLength = this.value.length();
        this.highlightPosition = class_3532.method_15340((int)position, (int)0, (int)valueLength);
        if (this.displayPosition > valueLength) {
            this.displayPosition = valueLength;
        }
        int innerWidth = this.getInnerWidth();
        String string = RenderUtil.stringToWidth(this.value.substring(this.displayPosition), innerWidth);
        int l = string.length() + this.displayPosition;
        if (this.highlightPosition == this.displayPosition) {
            this.displayPosition -= RenderUtil.stringToWidth(this.value, innerWidth, true).length();
        }
        if (this.highlightPosition > l) {
            this.displayPosition += this.highlightPosition - l;
        } else if (this.highlightPosition <= this.displayPosition) {
            this.displayPosition -= this.displayPosition - this.highlightPosition;
        }
        this.displayPosition = class_3532.method_15340((int)this.displayPosition, (int)0, (int)valueLength);
    }

    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    public void moveCursorToEnd() {
        this.moveCursorTo(this.value.length());
    }

    public void moveCursorTo(int i) {
        this.setCursorPosition(i);
        if (!this.shiftPressed) {
            this.setHighlightPos(this.cursorPosition);
        }
        this.onValueChange(this.value);
    }

    private void onValueChange(String string) {
        if (this.responder != null) {
            this.responder.accept(string);
        }
    }

    @Override
    protected McTextComponent createNarrationMessage() {
        return McTextComponent.translatable("gui.narrate.editBox", this.getText(), this.value);
    }

    public static String filterText(String string) {
        char[] var2;
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : var2 = string.toCharArray()) {
            if (!TextFieldWidget.isAllowedChatCharacter(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean isAllowedChatCharacter(char c) {
        return c != '\u00a7' && c >= ' ' && c != '\u007f';
    }

    public static int offsetByCodepoints(String string, int i, int j) {
        int k = string.length();
        if (j >= 0) {
            for (int l = 0; i < k && l < j; ++l) {
                if (!Character.isHighSurrogate(string.charAt(i++)) || i >= k || !Character.isLowSurrogate(string.charAt(i))) continue;
                ++i;
            }
        } else {
            for (int l = j; i > 0 && l < 0; ++l) {
                if (!Character.isLowSurrogate(string.charAt(--i)) || i <= 0 || !Character.isHighSurrogate(string.charAt(i - 1))) continue;
                --i;
            }
        }
        return i;
    }

    public void setResponder(@Nullable Consumer<String> responder) {
        this.responder = responder;
    }

    public void setFilter(Predicate<String> filter2) {
        this.filter = filter2;
    }

    public void setFormatter(BiFunction<String, Integer, McTextComponent> formatter) {
        this.formatter = formatter;
    }

    public String getValue() {
        return this.value;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean bordered) {
        this.bordered = bordered;
    }

    public boolean isCanLoseFocus() {
        return this.canLoseFocus;
    }

    public void setCanLoseFocus(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setTextColorUneditable(int textColorUneditable) {
        this.textColorUneditable = textColorUneditable;
    }

    public void setSuggestion(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }
}

