/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.audio.codec.opus;

import com.plasmoverse.opus.OpusEncoder;
import com.plasmoverse.opus.OpusException;
import com.plasmoverse.opus.OpusMode;
import java.io.IOException;
import java.util.Arrays;
import su.plo.voice.api.audio.codec.CodecException;
import su.plo.voice.audio.codec.opus.BaseOpusEncoder;

public final class NativeOpusEncoder
implements BaseOpusEncoder {
    private final int sampleRate;
    private final int channels;
    private final su.plo.voice.proto.data.audio.codec.opus.OpusMode opusMode;
    private final int mtuSize;
    private OpusEncoder encoder;

    public NativeOpusEncoder(int sampleRate, boolean stereo, su.plo.voice.proto.data.audio.codec.opus.OpusMode opusMode, int mtuSize) {
        this.sampleRate = sampleRate;
        this.channels = stereo ? 2 : 1;
        this.opusMode = opusMode;
        this.mtuSize = mtuSize;
    }

    @Override
    public byte[] encode(short[] samples) throws CodecException {
        if (!this.isOpen()) {
            throw new CodecException("Encoder is not open");
        }
        try {
            return this.encoder.encode(samples);
        }
        catch (OpusException e) {
            throw new CodecException("Failed to encode audio", e);
        }
    }

    @Override
    public void open() throws CodecException {
        try {
            OpusMode mode = Arrays.stream(OpusMode.values()).filter(element -> element.getApplication() == this.opusMode.getApplication()).findFirst().orElseThrow(() -> new CodecException("Invalid opus application mode"));
            this.encoder = OpusEncoder.create(this.sampleRate, this.channels == 2, this.mtuSize, mode);
        }
        catch (OpusException | IOException e) {
            throw new CodecException("Failed to open opus encoder", e);
        }
    }

    @Override
    public void reset() {
        if (!this.isOpen()) {
            return;
        }
        this.encoder.reset();
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.encoder.close();
        this.encoder = null;
    }

    @Override
    public boolean isOpen() {
        return this.encoder != null;
    }

    @Override
    public void setBitrate(int bitrate) {
        if (!this.isOpen()) {
            return;
        }
        this.encoder.setBitrate(bitrate);
    }

    @Override
    public int getBitrate() {
        try {
            return this.encoder.getBitrate();
        }
        catch (OpusException e) {
            return 0;
        }
    }
}

