/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client;

import java.io.File;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.slib.api.logging.McLoggerFactory;
import su.plo.slib.mod.channel.ByteArrayCodec;
import su.plo.slib.mod.channel.ModChannelManager;
import su.plo.slib.mod.logging.Log4jLogger;
import su.plo.voice.api.client.audio.device.DeviceFactoryManager;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.audio.device.AlInputDeviceFactory;
import su.plo.voice.client.audio.device.AlOutputDeviceFactory;
import su.plo.voice.client.audio.device.JavaxInputDeviceFactory;
import su.plo.voice.client.connection.ModClientChannelHandler;
import su.plo.voice.client.event.key.KeyPressedEvent;
import su.plo.voice.client.gui.settings.VoiceScreens;
import su.plo.voice.client.render.ModHudRenderer;
import su.plo.voice.client.render.ModLevelRenderer;
import su.plo.voice.server.ModVoiceServer;
import su.plo.voice.util.version.ModrinthLoader;

public final class ModVoiceClient
extends BaseVoiceClient
implements ClientModInitializer {
    public static ModVoiceClient INSTANCE;
    private final String modId = "plasmovoice";
    public static final class_304 MENU_KEY;
    private final ModHudRenderer hudRenderer;
    private final ModLevelRenderer levelRenderer;
    private final ModClientChannelHandler handler = new ModClientChannelHandler(this);

    public ModVoiceClient() {
        super(ModrinthLoader.FABRIC);
        McLoggerFactory.supplier = Log4jLogger::new;
        DeviceFactoryManager factoryManager = this.getDeviceFactoryManager();
        factoryManager.registerDeviceFactory(new AlOutputDeviceFactory(this));
        factoryManager.registerDeviceFactory(new AlInputDeviceFactory(this));
        this.getDeviceFactoryManager().registerDeviceFactory(new JavaxInputDeviceFactory(this));
        this.hudRenderer = new ModHudRenderer(this);
        this.levelRenderer = new ModLevelRenderer(this);
        INSTANCE = this;
        RenderUtil.getTextConverter().setLanguageSupplier(this.createLanguageSupplier());
    }

    @Override
    protected void onServerDisconnect() {
        super.onServerDisconnect();
        this.handler.close();
    }

    @EventSubscribe
    public void onKeyPressed(@NotNull KeyPressedEvent event) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        if (MENU_KEY.method_1436()) {
            VoiceScreens.INSTANCE.openSettings(this);
        }
    }

    @Override
    @NotNull
    public File getConfigFolder() {
        return new File("config/plasmovoice");
    }

    @Override
    public Optional<ServerConnection> getServerConnection() {
        return this.handler.getConnection();
    }

    public void onInitializeClient() {
        super.onInitialize();
        ClientLifecycleEvents.CLIENT_STOPPING.register(minecraft -> this.onShutdown());
        HudRenderCallback.EVENT.register(this.hudRenderer::render);
        WorldRenderEvents.LAST.register(context -> this.levelRenderer.render(context.world(), context.matrixStack(), context.camera(), context.tickCounter().method_60638()));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> this.onServerDisconnect());
        ByteArrayCodec voiceChannelCodec = ModChannelManager.Companion.getOrRegisterCodec(ModVoiceServer.CHANNEL);
        ByteArrayCodec flagChannelCodec = ModChannelManager.Companion.getOrRegisterCodec(ModVoiceServer.FLAG_CHANNEL);
        ClientPlayNetworking.registerGlobalReceiver(voiceChannelCodec.getType(), (ClientPlayNetworking.PlayPayloadHandler)this.handler);
        ClientPlayNetworking.registerGlobalReceiver(flagChannelCodec.getType(), (payload, context) -> {});
        KeyBindingHelper.registerKeyBinding((class_304)MENU_KEY);
    }

    public ModHudRenderer getHudRenderer() {
        return this.hudRenderer;
    }

    public ModLevelRenderer getLevelRenderer() {
        return this.levelRenderer;
    }

    static {
        MENU_KEY = new class_304("key.plasmovoice.settings", class_3675.class_307.field_1668, 86, "Plasmo Voice");
    }
}

