/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.tab;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.MinecraftUtil;
import su.plo.lib.mod.client.gui.components.AbstractScrollbar;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidgetListener;
import su.plo.lib.mod.client.language.LanguageUtil;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.texture.ModPlayerSkins;
import su.plo.slib.api.chat.component.McLiteralText;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.tab.TabWidget;
import su.plo.voice.client.meta.Patron;
import su.plo.voice.client.meta.PlasmoVoiceMeta;
import su.plo.voice.client.meta.developer.Developer;

public final class AboutTabWidget
extends TabWidget {
    public AboutTabWidget(@NotNull VoiceSettingsScreen parent, @NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config) {
        super(parent, voiceClient, config);
    }

    @Override
    public void init() {
        super.init();
        this.loadSkins();
        this.addEntry(new TabWidget.CategoryEntry(this, this.madeBy(), 24));
        PlasmoVoiceMeta.Companion.getMETA().getDevelopers().forEach(developer -> this.addEntry(new DeveloperEntry((Developer)developer)));
        this.addEntry(new TabWidget.CategoryEntry(this, this.links(), 24));
        this.addEntry(new ListEntry(this, (List<GuiAbstractWidget>)ImmutableList.of((Object)new Button(0, 0, 0, 20, McTextComponent.literal("Github"), button -> this.openLink("https://github.com/plasmoapp/plasmo-voice"), (button, matrices, mouseX, mouseY) -> this.setTooltip(McTextComponent.literal("https://github.com/plasmoapp/plasmo-voice"))), (Object)new Button(0, 0, 0, 20, McTextComponent.literal("Discord"), button -> this.openLink("https://discord.com/invite/uueEqzwCJJ"), (button, matrices, mouseX, mouseY) -> this.setTooltip(McTextComponent.literal("https://discord.com/invite/uueEqzwCJJ"))))));
        this.addEntry(new ListEntry(this, (List<GuiAbstractWidget>)ImmutableList.of((Object)new Button(0, 0, 0, 20, McTextComponent.literal("Modrinth"), button -> this.openLink("https://modrinth.com/mod/plasmo-voice"), (button, matrices, mouseX, mouseY) -> this.setTooltip(McTextComponent.literal("https://modrinth.com/mod/plasmo-voice"))), (Object)new Button(0, 0, 0, 20, McTextComponent.literal("Spigot"), button -> this.openLink("https://www.spigotmc.org/resources/plasmo-voice-server.91064/"), (button, matrices, mouseX, mouseY) -> this.setTooltip(McTextComponent.literal("https://www.spigotmc.org/resources/plasmo-voice-server.91064/"))))));
        this.addEntry(new ListEntry(this, (List<GuiAbstractWidget>)ImmutableList.of((Object)new Button(0, 0, 0, 20, McTextComponent.literal("Patreon"), button -> this.openLink("https://www.patreon.com/plasmomc"), (button, matrices, mouseX, mouseY) -> this.setTooltip(McTextComponent.literal("https://www.patreon.com/plasmomc"))), (Object)new Button(0, 0, 0, 20, McTextComponent.literal("Boosty"), button -> this.openLink("https://boosty.to/plasmo"), (button, matrices, mouseX, mouseY) -> this.setTooltip(McTextComponent.literal("https://boosty.to/plasmo"))))));
        this.addEntry(new TextEntry(this, McTextComponent.translatable("gui.plasmovoice.about.copyright", new Object[0])));
        if (PlasmoVoiceMeta.Companion.getMETA().getPatrons().size() > 0) {
            this.addEntry(new TabWidget.CategoryEntry(this, McTextComponent.translatable("gui.plasmovoice.about.support", new Object[0]), 24));
            PlasmoVoiceMeta.Companion.getMETA().getPatrons().forEach(patron -> this.addEntry(new PatronEntry(this, (Patron)patron)));
        }
    }

    private McTextComponent madeBy() {
        McTextComponent madeBy = McTextComponent.translatable("gui.plasmovoice.about.made_by", "Plasmo Voice");
        if (!LanguageUtil.getOrDefault("gui.plasmovoice.about.made_by").contains("%s")) {
            madeBy = McTextComponent.literal("Plasmo Voice is made by");
        }
        return madeBy;
    }

    private McTextComponent links() {
        McTextComponent links = McTextComponent.translatable("gui.plasmovoice.about.links", "Plasmo Voice");
        if (!LanguageUtil.getOrDefault("gui.plasmovoice.about.links").contains("%s")) {
            links = McTextComponent.literal("Plasmo Voice on");
        }
        return links;
    }

    private void openLink(@NotNull String link) {
        MinecraftUtil.openUri(link);
    }

    private void loadSkins() {
        PlasmoVoiceMeta.Companion.getMETA().getDevelopers().forEach(developer -> ModPlayerSkins.loadSkin(developer.getUuid(), developer.getName(), this.voiceClient.getBackgroundExecutor()));
        PlasmoVoiceMeta.Companion.getMETA().getPatrons().forEach(patron -> ModPlayerSkins.loadSkin(patron.getUuid(), patron.getName(), this.voiceClient.getBackgroundExecutor()));
    }

    class ListEntry
    extends AbstractScrollbar.Entry {
        private final List<GuiAbstractWidget> widgets;

        public ListEntry(AboutTabWidget this$0, List<GuiAbstractWidget> widgets) {
            super(24);
            this.widgets = widgets;
        }

        @Override
        public List<? extends GuiWidgetListener> widgets() {
            return this.widgets;
        }

        @Override
        public void render(@NotNull class_4587 stack, int index, int x, int y, int entryWidth, int mouseX, int mouseY, boolean hovered, float delta) {
            int gap = 4;
            int elementWidth = entryWidth / this.widgets.size() - (this.widgets.size() - 1) * (gap / 2);
            if (elementWidth % 2 == 1) {
                gap = (entryWidth - ++elementWidth * this.widgets.size()) / (this.widgets.size() - 1);
            }
            int elementX = x;
            for (GuiAbstractWidget element : this.widgets) {
                element.setX(elementX);
                element.setY(y);
                element.setWidth(elementWidth);
                element.render(stack, mouseX, mouseY, delta);
                elementX += elementWidth + gap;
            }
        }
    }

    class TextEntry
    extends AbstractScrollbar.Entry {
        private final McTextComponent text;

        public TextEntry(@NotNull AboutTabWidget this$0, McTextComponent text) {
            super(28);
            this.text = text;
        }

        @Override
        public void render(@NotNull class_4587 stack, int index, int x, int y, int entryWidth, int mouseX, int mouseY, boolean hovered, float delta) {
            int lines = RenderUtil.drawStringMultiLine(stack, this.text, x, y + 16, -8355712, entryWidth);
            this.setHeight(lines * RenderUtil.getFontHeight() + 16);
        }

        @Override
        public boolean changeFocus(boolean lookForwards) {
            return false;
        }
    }

    class PatronEntry
    extends AbstractScrollbar.Entry {
        private final Patron patron;

        public PatronEntry(@NotNull AboutTabWidget this$0, Patron patron) {
            super(22);
            this.patron = patron;
        }

        @Override
        public void render(@NotNull class_4587 stack, int index, int x, int y, int entryWidth, int mouseX, int mouseY, boolean hovered, float delta) {
            this.renderBackground(stack, x, y, entryWidth);
            RenderUtil.bindTexture(0, ModPlayerSkins.getSkin(this.patron.getUuid(), this.patron.getName()));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.blit(stack, x + 2, y + 2, 16, 16, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderUtil.blit(stack, x + 2, y + 2, 16, 16, 40.0f, 8.0f, 8, 8, 64, 64);
            RenderUtil.drawString(stack, this.patron.getName(), x + 26, y + 6, 0xFFFFFF);
            McLiteralText tier = McTextComponent.literal(this.patron.getTier());
            RenderUtil.drawString(stack, tier, x + entryWidth - RenderUtil.getTextWidth(tier) - 6, y + 6, -5592406);
        }

        public void renderBackground(@NotNull class_4587 stack, int x, int y, int entryWidth) {
            int height = this.height - 2;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.bindTexture(0, class_310.method_1551().field_1687 == null ? GuiWidget.MENU_LIST_BACKGROUND_LOCATION : GuiWidget.INWORLD_MENU_LIST_BACKGROUND_LOCATION);
            RenderUtil.blit(stack, x, x + entryWidth, y, y + height, 0, 0.0f, (float)entryWidth / 32.0f, 0.0f, (float)height / 32.0f);
        }

        @Override
        public List<? extends GuiWidgetListener> widgets() {
            return Collections.emptyList();
        }
    }

    class DeveloperEntry
    extends AbstractScrollbar.Entry {
        private final Developer developer;
        private final Button link;

        public DeveloperEntry(Developer developer) {
            super(44);
            this.developer = developer;
            this.link = new Button(0, 0, 56, 20, McTextComponent.literal(developer.getSocialLinkName()), button -> AboutTabWidget.this.openLink(developer.getSocialLinkUrl()), (button, matrices, mouseX, mouseY) -> AboutTabWidget.this.setTooltip(McTextComponent.literal(developer.getSocialLinkUrl())));
        }

        @Override
        public void render(@NotNull class_4587 stack, int index, int x, int y, int entryWidth, int mouseX, int mouseY, boolean hovered, float delta) {
            this.renderBackground(stack, x, y, entryWidth);
            RenderUtil.bindTexture(0, ModPlayerSkins.getSkin(this.developer.getUuid(), this.developer.getName()));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.blit(stack, x + 4, y + 4, 32, 32, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderUtil.blit(stack, x + 4, y + 4, 32, 32, 40.0f, 8.0f, 8, 8, 64, 64);
            RenderUtil.drawString(stack, this.developer.getName(), x + 40, y + 11, 0xFFFFFF);
            RenderUtil.drawString(stack, this.developer.getRole().getTranslatable(), x + 40, y + 21, -5592406);
            if (this.link != null) {
                this.link.setX(x + entryWidth - 62);
                this.link.setY(y + 10);
                this.link.render(stack, mouseX, mouseY, delta);
            }
        }

        public void renderBackground(@NotNull class_4587 stack, int x, int y, int entryWidth) {
            int height = this.height - 4;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.bindTexture(0, class_310.method_1551().field_1687 == null ? GuiWidget.MENU_LIST_BACKGROUND_LOCATION : GuiWidget.INWORLD_MENU_LIST_BACKGROUND_LOCATION);
            RenderUtil.blit(stack, x, x + entryWidth, y, y + height, 0, 0.0f, (float)entryWidth / 32.0f, 0.0f, (float)height / 32.0f);
        }

        @Override
        public List<? extends GuiWidgetListener> widgets() {
            return ImmutableList.of((Object)this.link);
        }
    }
}

