/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.tab;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.EnumConfigEntry;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.gui.screen.ScreenWrapper;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.api.client.config.IconPosition;
import su.plo.voice.client.gui.settings.HudPositionScreen;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;

public final class ActivationIconPositionScreen
extends HudPositionScreen<IconPosition> {
    private final IconPosition disabledPosition;

    public ActivationIconPositionScreen(@NotNull VoiceSettingsScreen parent, @NotNull EnumConfigEntry<IconPosition> entry, @Nullable IconPosition disabledPosition) {
        super(parent, entry, McTextComponent.translatable("gui.plasmovoice.overlay.activation_icon_position.choose", new Object[0]));
        this.disabledPosition = disabledPosition;
    }

    @Override
    public void init() {
        super.init();
        int width = this.getWidth();
        int height = this.getHeight();
        this.addRenderWidget(this.createPositionButton(25, 25, IconPosition.TOP_LEFT));
        this.addRenderWidget(this.createPositionButton(width / 2 - 50, 25, IconPosition.TOP_CENTER));
        this.addRenderWidget(this.createPositionButton(width - 25 - 100, 25, IconPosition.TOP_RIGHT));
        this.addRenderWidget(this.createPositionButton(25, height - 20 - 25, IconPosition.BOTTOM_LEFT));
        this.addRenderWidget(this.createPositionButton(width / 2 - 50, height - 20 - 25, IconPosition.BOTTOM_CENTER));
        this.addRenderWidget(this.createPositionButton(width - 25 - 100, height - 20 - 25, IconPosition.BOTTOM_RIGHT));
    }

    @Override
    protected Button createPositionButton(int x, int y, IconPosition iconPosition) {
        Button button = new Button(x, y, 100, 20, McTextComponent.translatable(iconPosition.getTranslation(), new Object[0]), btn -> {
            this.entry.set(iconPosition);
            ScreenWrapper.openScreen(this.parent);
        }, Button.NO_TOOLTIP);
        button.setActive(iconPosition != this.disabledPosition);
        return button;
    }
}

