/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render.voice;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.render.LazyGlState;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.pipeline.RenderPipelines;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.api.client.config.IconPosition;
import su.plo.voice.api.client.event.render.HudActivationRenderEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.event.render.HudRenderEvent;
import su.plo.voice.proto.data.audio.capture.Activation;

public final class HudIconRenderer {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    @NotNull
    private final LazyGlState glState = new LazyGlState();

    @EventSubscribe
    public void onHudRender(@NotNull HudRenderEvent event) {
        if (!this.voiceClient.getServerInfo().isPresent() || !this.voiceClient.getUdpClientManager().getClient().isPresent() || class_310.method_1551().field_1724 == null || !((Boolean)this.config.getOverlay().getShowActivationIcon().value()).booleanValue() || class_310.method_1551().field_1690.field_1842) {
            return;
        }
        if (this.voiceClient.getUdpClientManager().getClient().get().isTimedOut()) {
            this.renderIcon(event.getStack(), class_2960.method_12829((String)"plasmovoice:textures/icons/microphone_disconnected.png"));
            return;
        }
        if (((Boolean)this.config.getVoice().getDisabled().value()).booleanValue()) {
            this.renderIcon(event.getStack(), class_2960.method_12829((String)"plasmovoice:textures/icons/speaker_disabled.png"));
            return;
        }
        if (this.voiceClient.getAudioCapture().isServerMuted()) {
            this.renderIcon(event.getStack(), class_2960.method_12829((String)"plasmovoice:textures/icons/microphone_muted.png"));
            return;
        }
        if (((Boolean)this.config.getVoice().getMicrophoneDisabled().value()).booleanValue()) {
            this.renderIcon(event.getStack(), class_2960.method_12829((String)"plasmovoice:textures/icons/microphone_disabled.png"));
            return;
        }
        List activations = (List)this.voiceClient.getActivationManager().getActivations();
        Activation currentActivation = null;
        for (int index = activations.size() - 1; index >= 0; --index) {
            ClientActivation activation = (ClientActivation)activations.get(index);
            HudActivationRenderEvent renderEvent = new HudActivationRenderEvent(activation, activation.isActive());
            this.voiceClient.getEventBus().fire(renderEvent);
            if (!renderEvent.isRender()) continue;
            currentActivation = activation;
            if (!activation.isTransitive()) break;
        }
        if (currentActivation != null) {
            this.renderIcon(event.getStack(), class_2960.method_12829((String)currentActivation.getIcon()));
        }
    }

    private void renderIcon(@NotNull class_4587 stack, @NotNull class_2960 iconLocation) {
        IconPosition iconPosition = (IconPosition)((Object)this.config.getOverlay().getActivationIconPosition().value());
        RenderUtil.bindTexture(0, iconLocation);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.method_22903();
        stack.method_46416(0.0f, 0.0f, 1000.0f);
        this.glState.withState(() -> RenderUtil.blitWithPipeline(stack, RenderPipelines.GUI_TEXTURE_OVERLAY, this.calcIconX(iconPosition.getX()), this.calcIconY(iconPosition.getY()), 0.0f, 0.0f, 16, 16, 16, 16));
        stack.method_22909();
    }

    private int calcIconX(Integer x) {
        class_1041 window = class_310.method_1551().method_22683();
        if (x == null) {
            return window.method_4486() / 2 - 8;
        }
        if (x < 0) {
            return window.method_4486() + x - 16;
        }
        return x;
    }

    private int calcIconY(Integer y) {
        class_1041 window = class_310.method_1551().method_22683();
        if (y == null) {
            return window.method_4502() - 32;
        }
        if (y < 0) {
            return window.method_4502() + y - 16;
        }
        return y;
    }

    public HudIconRenderer(PlasmoVoiceClient voiceClient, VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.config = config;
    }
}

