/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.serverbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.tcp.serverbound.ServerPacketTcpHandler;

public final class PlayerAudioEndPacket
implements Packet<ServerPacketTcpHandler> {
    private long sequenceNumber;
    private UUID activationId;
    private short distance;

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.sequenceNumber = in.readLong();
        this.activationId = PacketUtil.readUUID(in);
        this.distance = in.readShort();
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        out.writeLong(this.sequenceNumber);
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.activationId));
        out.writeShort((int)this.distance);
    }

    @Override
    public void handle(ServerPacketTcpHandler handler) {
        handler.handle(this);
    }

    public PlayerAudioEndPacket() {
    }

    public PlayerAudioEndPacket(long sequenceNumber, UUID activationId, short distance) {
        this.sequenceNumber = sequenceNumber;
        this.activationId = activationId;
        this.distance = distance;
    }

    public String toString() {
        return "PlayerAudioEndPacket(sequenceNumber=" + this.getSequenceNumber() + ", activationId=" + this.getActivationId() + ", distance=" + this.getDistance() + ")";
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public UUID getActivationId() {
        return this.activationId;
    }

    public short getDistance() {
        return this.distance;
    }
}

