/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.command;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.chat.component.McTranslatableText;
import su.plo.slib.api.command.McCommand;
import su.plo.slib.api.command.McCommandSource;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.slib.api.server.McServerLib;
import su.plo.voice.api.server.mute.ServerMuteInfo;
import su.plo.voice.server.BaseVoiceServer;
import su.plo.voice.server.mute.VoiceMuteManager;

public final class VoiceMuteListCommand
implements McCommand {
    private final BaseVoiceServer voiceServer;
    private final McServerLib minecraftServer;

    @Override
    public void execute(@NotNull McCommandSource source2, @NotNull String[] arguments) {
        VoiceMuteManager muteManager = (VoiceMuteManager)this.voiceServer.getMuteManager();
        Collection<ServerMuteInfo> mutedPlayers = muteManager.getMuteStorage().getMutedPlayers();
        source2.sendMessage(McTextComponent.translatable("pv.command.mute_list.header", new Object[0]));
        if (mutedPlayers.isEmpty()) {
            source2.sendMessage(McTextComponent.translatable("pv.command.mute_list.empty", new Object[0]));
            return;
        }
        mutedPlayers.forEach(muteInfo -> {
            McGameProfile player = this.minecraftServer.getGameProfile(muteInfo.getPlayerUUID());
            McGameProfile mutedBy = null;
            if (muteInfo.getMutedByPlayerUUID() != null) {
                mutedBy = this.minecraftServer.getGameProfile(muteInfo.getMutedByPlayerUUID());
            }
            if (player == null) {
                return;
            }
            Map<String, String> language = this.voiceServer.getLanguages().getServerLanguage(source2);
            Date date = new Date(muteInfo.getMutedToTime());
            SimpleDateFormat expirationFormatDate = new SimpleDateFormat(language.getOrDefault("pv.command.mute_list.expiration_date", "yyyy.MM.dd"));
            SimpleDateFormat expirationFormatTime = new SimpleDateFormat(language.getOrDefault("pv.command.mute_list.expiration_time", "HH:mm:ss"));
            McTranslatableText expires = muteInfo.getMutedToTime() > 0L ? McTextComponent.translatable("pv.command.mute_list.expire_at", expirationFormatDate.format(date), expirationFormatTime.format(date)) : McTextComponent.translatable("pv.command.mute_list.never_expires", new Object[0]);
            McTextComponent reason = muteManager.formatMuteReason(muteInfo.getReason());
            if (mutedBy != null) {
                source2.sendMessage(McTextComponent.translatable("pv.command.mute_list.entry_muted_by", player.getName(), mutedBy.getName(), expires, reason));
            } else {
                source2.sendMessage(McTextComponent.translatable("pv.command.mute_list.entry", player.getName(), expires, reason));
            }
        });
    }

    @Override
    public boolean hasPermission(@NotNull McCommandSource source2, @Nullable String[] arguments) {
        return source2.hasPermission("pv.mutelist");
    }

    public VoiceMuteListCommand(BaseVoiceServer voiceServer, McServerLib minecraftServer) {
        this.voiceServer = voiceServer;
        this.minecraftServer = minecraftServer;
    }
}

