/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames;

import com.HiWord9.RPRenames.RPRenames;
import com.HiWord9.RPRenames.modConfig.ModConfig;
import com.HiWord9.RPRenames.util.config.PropertiesHelper;
import com.HiWord9.RPRenames.util.config.generation.ParserHelper;
import com.HiWord9.RPRenames.util.rename.type.AbstractRename;
import com.HiWord9.RPRenames.util.rename.type.CEMRename;
import com.HiWord9.RPRenames.util.rename.type.CITRename;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2287;
import net.minecraft.class_2509;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9335;

public class RPRenamesCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"rprenames").then(ClientCommandManager.literal((String)"info").executes(context -> RPRenamesCommand.info((FabricClientCommandSource)context.getSource())))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"list").executes(context -> RPRenamesCommand.list((FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.argument((String)"item", (ArgumentType)class_2287.method_9776((class_7157)commandRegistryAccess)).executes(context -> RPRenamesCommand.list((FabricClientCommandSource)context.getSource(), class_2287.method_9777((CommandContext)context, (String)"item").method_9785()))))).then(ClientCommandManager.literal((String)"solveRegex").then(ClientCommandManager.argument((String)"regex", (ArgumentType)StringArgumentType.greedyString()).executes(context -> RPRenamesCommand.solveRegex((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"regex")))))).then(ClientCommandManager.literal((String)"disableHints").executes(context -> RPRenamesCommand.disableHints((FabricClientCommandSource)context.getSource()))));
    }

    private static int disableHints(FabricClientCommandSource source) {
        ModConfig config = ModConfig.INSTANCE;
        config.disableTooltipHints = !config.disableTooltipHints;
        config.write();
        if (config.disableTooltipHints) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"rprenames.command.disableHints.disabled").method_27692(class_124.field_1065));
            source.sendFeedback((class_2561)class_2561.method_43469((String)"rprenames.command.disableHints.howToTurnOn", (Object[])new Object[]{class_2561.method_43471((String)"rprenames.gui.tooltipHint.disable.command").method_27692(class_124.field_1060)}).method_27692(class_124.field_1065));
        } else {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"rprenames.command.disableHints.enabled").method_27692(class_124.field_1065));
        }
        return 1;
    }

    public static int info(FabricClientCommandSource source) {
        class_1799 itemStack = source.getPlayer().method_5998(class_1268.field_5808);
        if (itemStack.method_7960()) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"rprenames.command.info.noItemGiven").method_27692(class_124.field_1061));
            return 1;
        }
        AbstractRename matchRename = null;
        ArrayList<AbstractRename> renames = RPRenames.renamesManager.getRenames(itemStack.method_7909());
        if (!renames.isEmpty()) {
            matchRename = RPRenamesCommand.getMatch(renames, itemStack);
        }
        if (matchRename == null) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"rprenames.command.info.noRenamesFound").method_27692(class_124.field_1061));
            return 1;
        }
        source.sendFeedback((class_2561)class_2561.method_43471((String)"rprenames.command.info.foundProperties").method_27692(class_124.field_1054));
        RPRenamesCommand.printAbstractRenameInfo(matchRename, source);
        if (matchRename instanceof CEMRename) {
            CEMRename cemRename = (CEMRename)matchRename;
            source.sendFeedback((class_2561)class_2561.method_43471((String)"rprenames.command.info.cemProperties").method_27692(class_124.field_1076));
            RPRenamesCommand.printCemRenameInfo(cemRename, source);
        }
        return 1;
    }

    public static void printAbstractRenameInfo(AbstractRename rename, FabricClientCommandSource source) {
        RPRenamesCommand.printRenameInfo(rename.getPackName(), rename.getPath(), rename.getProperties(), source);
    }

    public static void printCemRenameInfo(CEMRename rename, FabricClientCommandSource source) {
        RPRenamesCommand.printRenameInfo(rename.getMob().getPackName(), rename.getMob().getPath(), rename.getMob().getProperties(), source);
    }

    public static void printRenameInfo(String packName, String path, Properties properties, FabricClientCommandSource source) {
        if (properties != null) {
            RPRenamesCommand.printProperties(properties, source);
        }
        if (packName != null && path != null) {
            RPRenamesCommand.printPath(path, packName, source);
        }
        if (path == null) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"rprenames.command.info.noPath").method_27692(class_124.field_1061));
        }
        if (packName == null) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"rprenames.command.info.noRpName").method_27692(class_124.field_1061));
        } else {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"rprenames.command.info.rpName").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_30163((String)" = ").method_27661().method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_30163((String)packName).method_27661().method_27692(class_124.field_1078)));
        }
    }

    public static int list(FabricClientCommandSource source) {
        return RPRenamesCommand.list(source, source.getPlayer().method_5998(class_1268.field_5808).method_7909());
    }

    public static int list(FabricClientCommandSource source, class_1792 item) {
        ArrayList<AbstractRename> renames = RPRenames.renamesManager.getRenames(item);
        if (!renames.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_43469((String)"rprenames.command.list.foundRenames", (Object[])new Object[]{class_2561.method_43471((String)item.method_7876())}));
            RPRenamesCommand.printRenameList(renames, source);
        } else {
            source.sendFeedback((class_2561)class_2561.method_43469((String)"rprenames.command.list.noRenamesFound", (Object[])new Object[]{class_2561.method_43471((String)item.method_7876())}).method_27692(class_124.field_1061));
        }
        return 1;
    }

    private static int solveRegex(FabricClientCommandSource source, String regex) {
        String result = PropertiesHelper.solveRegex(PropertiesHelper.parseEscapes(regex));
        Pattern pattern = Pattern.compile(regex);
        if (pattern.matcher(result).matches()) {
            source.sendFeedback((class_2561)class_2561.method_30163((String)result).method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1076).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)regex))).method_10958(new class_2558(class_2558.class_2559.field_21462, result))));
        } else {
            source.sendError((class_2561)class_2561.method_43471((String)"rprenames.command.solveRegex.error").method_27696(class_2583.field_24360.method_10977(class_124.field_1061).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)regex).method_27661().method_27692(class_124.field_1061)))));
        }
        return 1;
    }

    private static AbstractRename getMatch(ArrayList<AbstractRename> renames, class_1799 stack) {
        String name = stack.method_7964().getString();
        for (AbstractRename r : renames) {
            CITRename citRename;
            boolean nameValid;
            String nbtName = r.getNamePattern();
            boolean caseInsensitive = false;
            if (nbtName.startsWith("iregex:") || nbtName.startsWith("ipattern:")) {
                nbtName = nbtName.substring(1);
                caseInsensitive = true;
            }
            if (nbtName.startsWith("regex:") || nbtName.startsWith("pattern:")) {
                if (nbtName.startsWith("regex:")) {
                    nbtName = nbtName.substring(6);
                } else if (nbtName.startsWith("pattern:")) {
                    nbtName = nbtName.substring(8);
                    nbtName = nbtName.replace("*", ".*").replace("?", ".+");
                }
                nbtName = PropertiesHelper.parseEscapes(nbtName);
                Pattern pattern = Pattern.compile(caseInsensitive ? nbtName.toUpperCase(Locale.ROOT) : nbtName);
                nameValid = pattern.matcher(caseInsensitive ? name.toUpperCase(Locale.ROOT) : name).matches();
            } else {
                nameValid = name.equals(r.getName());
            }
            if (!nameValid || r instanceof CITRename && !new CITRename.CraftMatcher(citRename = (CITRename)r, stack).matches()) continue;
            return r;
        }
        return null;
    }

    private static void printRenameList(ArrayList<AbstractRename> renames, FabricClientCommandSource source) {
        RPRenames.LOGGER.warn("Generating give commands with components, this may crash!");
        RPRenames.LOGGER.warn("If it is, please report the accident to https://github.com/HiWord9/RPRenames/issues");
        for (AbstractRename r : renames) {
            CITRename citRename;
            class_1799 itemStack = r.toStack();
            String components = RPRenamesCommand.getComponentsCommandArgument(source, itemStack);
            String giveCommand = "/give @s " + ParserHelper.getIdAndPath(itemStack.method_7909()) + components + (String)(r instanceof CITRename ? ((citRename = (CITRename)r).getStackSize() == 1 ? "" : " " + citRename.getStackSize()) : "");
            class_2558 runGive = new class_2558(class_2558.class_2559.field_11750, giveCommand);
            source.sendFeedback((class_2561)class_2561.method_43471((String)"rprenames.command.list.givePrefix").method_27696(class_2583.field_24360.method_10977(class_124.field_1080).method_10958(runGive).method_10975(giveCommand).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"rprenames.command.list.runGive")))).method_10852((class_2561)itemStack.method_7954().method_27661().method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, r.getName())))));
        }
    }

    private static <T> String getComponentsCommandArgument(FabricClientCommandSource source, class_1799 stack) {
        class_9326 changes = ((class_9335)stack.method_57353()).method_57940();
        if (changes.method_57848()) {
            return "";
        }
        StringBuilder resultBuilder = new StringBuilder();
        resultBuilder.append("[");
        for (Map.Entry entry : changes.method_57846()) {
            class_9331 componentType = (class_9331)entry.getKey();
            Optional optionalData = (Optional)entry.getValue();
            if (optionalData.isEmpty()) continue;
            class_2960 id = class_7923.field_49658.method_10221((Object)componentType);
            Object data = optionalData.get();
            class_6903 nbtOps = source.method_30497().method_57093((DynamicOps)class_2509.field_11560);
            Optional optionalDataResult = componentType.method_57876().encodeStart((DynamicOps)nbtOps, data).result();
            if (optionalDataResult.isEmpty()) continue;
            resultBuilder.append(id);
            resultBuilder.append("=");
            resultBuilder.append(optionalDataResult.get());
            resultBuilder.append(",");
        }
        if (resultBuilder.charAt(resultBuilder.length() - 1) == ',') {
            resultBuilder.deleteCharAt(resultBuilder.length() - 1);
        }
        resultBuilder.append("]");
        return resultBuilder.toString();
    }

    private static void printProperties(Properties properties, FabricClientCommandSource source) {
        for (String s : properties.stringPropertyNames()) {
            source.sendFeedback((class_2561)class_2561.method_30163((String)s).method_27661().method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_30163((String)"=").method_27661().method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_30163((String)properties.getProperty(s)).method_27661().method_27692(class_124.field_1060)));
        }
    }

    private static void printPath(String path, String packName, FabricClientCommandSource source) {
        String dirPath = path.substring(0, path.lastIndexOf("/"));
        source.sendFeedback((class_2561)class_2561.method_43469((String)"rprenames.command.info.located", (Object[])new Object[]{class_2561.method_30163((String)path).method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1054).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11746, (String)(packName.equals("server") ? "server-resource-packs/" : "resourcepacks/" + (packName.endsWith(".zip") ? packName : dirPath)))))}));
    }
}

