/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.modConfig;

import com.HiWord9.RPRenames.RPRenames;
import com.HiWord9.RPRenames.RPRenamesItemGroup;
import com.HiWord9.RPRenames.util.gui.widget.button.external.FavoriteButton;
import com.HiWord9.RPRenames.util.rename.renderer.PreviewTooltipPositioner;
import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

public class ModConfig {
    public boolean ignoreCEM = false;
    public boolean enableAnvilModification = true;
    public FavoriteButton.Position favoriteButtonPosition = FavoriteButton.Position.TOP_RIGHT;
    public boolean compareItemGroupRenames = true;
    public boolean generateSpawnEggsInItemGroup = true;
    public boolean loadModBuiltinResources = true;
    public boolean openByDefault = false;
    public boolean offsetMenu = true;
    public boolean showPackName = true;
    public boolean showExtraProperties = true;
    public boolean highlightSelected = true;
    public boolean recolorFavoriteTooltip = true;
    public boolean renderStarInFavoriteTooltip = false;
    public boolean highlightSlot = true;
    public int slotHighlightColorALPHA = 50;
    public int slotHighlightColorRGB = 0x80FFFF;
    public boolean highlightTooltipSlotWrong = true;
    public boolean highlightTooltipSlotSelected = false;
    public boolean enablePreview = true;
    public PreviewTooltipPositioner.PreviewPos previewPos = PreviewTooltipPositioner.PreviewPos.LEFT;
    public boolean playerPreviewByDefault = false;
    public boolean spinMobPreview = true;
    public boolean spinPlayerPreview = false;
    public boolean disableSnowGolemPumpkin = false;
    public double scaleFactorItem = 2.0;
    public double scaleFactorEntity = 1.0;
    public boolean alwaysAllowPlayerPreviewHead = false;
    public boolean disableTooltipHints = false;
    public boolean disablePageArrowsHints = false;
    public boolean updateConfig = true;
    public boolean showNamePattern = false;
    public boolean showOriginalProperties = false;
    public boolean fixDelayedPacketsChangingTab = false;
    public boolean showDescription = true;
    public static final ModConfig INSTANCE = ModConfig.read();
    protected Boolean shouldUpdateItemGroup = null;
    protected Boolean shouldUpdateRenamesList = null;

    public void setIgnoreCEM(boolean ignoreCEM) {
        if (this.shouldUpdateRenamesList == null || !this.shouldUpdateRenamesList.booleanValue()) {
            this.shouldUpdateRenamesList = ignoreCEM != this.ignoreCEM;
        }
        this.ignoreCEM = ignoreCEM;
    }

    public void setCompareItemGroupRenames(boolean compareItemGroupRenames) {
        if (this.shouldUpdateItemGroup == null || !this.shouldUpdateItemGroup.booleanValue()) {
            this.shouldUpdateItemGroup = compareItemGroupRenames != this.compareItemGroupRenames;
        }
        this.compareItemGroupRenames = compareItemGroupRenames;
    }

    public void setGenerateSpawnEggsInItemGroup(boolean generateSpawnEggsInItemGroup) {
        if (this.shouldUpdateItemGroup == null || !this.shouldUpdateItemGroup.booleanValue()) {
            this.shouldUpdateItemGroup = generateSpawnEggsInItemGroup != this.generateSpawnEggsInItemGroup;
        }
        this.generateSpawnEggsInItemGroup = generateSpawnEggsInItemGroup;
    }

    public int getSlotHighlightRGBA() {
        int a = (int)((float)this.slotHighlightColorALPHA / 100.0f * 255.0f);
        return a << 24 | this.slotHighlightColorRGB;
    }

    public static ModConfig read() {
        ModConfig modConfig;
        if (!RPRenames.MOD_CONFIG_FILE.exists()) {
            return new ModConfig().write();
        }
        FileReader reader = null;
        try {
            reader = new FileReader(RPRenames.MOD_CONFIG_FILE);
            modConfig = (ModConfig)new Gson().fromJson((Reader)reader, ModConfig.class);
        }
        catch (Exception e) {
            try {
                RPRenames.LOGGER.error("Could not read Config file", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return modConfig;
    }

    public ModConfig write() {
        if (this.shouldUpdateRenamesList != null && this.shouldUpdateRenamesList.booleanValue()) {
            RPRenames.renamesManager.updateRenames();
            this.shouldUpdateRenamesList = null;
        } else if (this.shouldUpdateItemGroup != null && this.shouldUpdateItemGroup.booleanValue()) {
            RPRenamesItemGroup.update();
        }
        this.shouldUpdateItemGroup = null;
        Gson gson = new Gson();
        JsonWriter writer = null;
        try {
            writer = gson.newJsonWriter((Writer)new FileWriter(RPRenames.MOD_CONFIG_FILE));
            writer.setIndent("    ");
            gson.toJson(gson.toJsonTree((Object)this, ModConfig.class), writer);
        }
        catch (Exception e) {
            try {
                RPRenames.LOGGER.error("Could not write Config file", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)writer);
        return this;
    }
}

