/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.util.config.favorite;

import com.HiWord9.RPRenames.util.config.favorite.FavoritesFileManager;
import com.HiWord9.RPRenames.util.config.favorite.TaskQueueThread;
import com.HiWord9.RPRenames.util.rename.RenamesManagerImpl;
import com.HiWord9.RPRenames.util.rename.type.AbstractRename;
import java.util.ArrayList;
import net.minecraft.class_1792;

public class FavoritesManager
extends RenamesManagerImpl {
    private final TaskQueueThread taskQueue = new TaskQueueThread();
    private final FavoritesFileManager favoritesFileManager;

    public FavoritesManager(FavoritesFileManager favoritesFileManager) {
        this.favoritesFileManager = favoritesFileManager;
        this.taskQueue.start();
    }

    public void loadSavedFavorites() {
        this.renames.putAll(this.favoritesFileManager.getAllSavedFavorites());
    }

    public void addRename(class_1792 item, String name) {
        this.addRename(item, new AbstractRename(name, item));
    }

    @Override
    public void addRename(class_1792 item, AbstractRename rename) {
        super.addRename(item, rename);
        this.taskQueue.addTask(() -> this.favoritesFileManager.setFavorites(this.getRenames(item), item));
    }

    public void removeRename(class_1792 item, String name) {
        this.removeRename(item, new AbstractRename(name, item));
    }

    @Override
    public void removeRename(class_1792 item, AbstractRename rename) {
        super.removeRename(item, rename);
        this.taskQueue.addTask(() -> this.favoritesFileManager.setFavorites(this.getRenames(item), item));
    }

    @Override
    public void overrideRenames(class_1792 item, ArrayList<AbstractRename> newRenames) {
        super.overrideRenames(item, newRenames);
        this.taskQueue.addTask(() -> this.favoritesFileManager.setFavorites(this.getRenames(item), item));
    }

    @Override
    public void clearRenames() {
        super.clearRenames();
        this.taskQueue.addTask(() -> this.favoritesFileManager.doomConfigs(this.renamedItems()));
    }

    public boolean isFavorite(class_1792 item, String name) {
        ArrayList<AbstractRename> favoriteList = this.getRenames(item);
        for (AbstractRename r : favoriteList) {
            if (!r.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isFavorite(class_1792 item, AbstractRename rename) {
        return this.getRenames(item).contains(rename);
    }
}

