/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.util.config.generation;

import com.HiWord9.RPRenames.RPRenames;
import com.HiWord9.RPRenames.modConfig.ModConfig;
import com.HiWord9.RPRenames.util.config.PropertiesHelper;
import com.HiWord9.RPRenames.util.config.generation.CEMModels;
import com.HiWord9.RPRenames.util.config.generation.Parser;
import com.HiWord9.RPRenames.util.config.generation.ParserHelper;
import com.HiWord9.RPRenames.util.rename.RenamesManager;
import com.HiWord9.RPRenames.util.rename.type.AbstractRename;
import com.HiWord9.RPRenames.util.rename.type.CEMRename;
import com.HiWord9.RPRenames.util.rename.type.CITRename;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public class CEMParser
implements Parser {
    private static final String CEM_PATH = "optifine/cem";
    private static final String RANDOM_ENTITY_PATH = "optifine/random/entity/";
    private static final String MOB_PATH = "optifine/mob/";
    private static final String PROP_EXTENSION = ".properties";
    private final ArrayList<String> checked = new ArrayList();
    public RenamesManager renamesManager;
    public static boolean ignoreSkip = false;

    public CEMParser(RenamesManager renamesManager) {
        this.renamesManager = renamesManager;
    }

    @Override
    public void parse(class_3300 resourceManager, class_3695 profiler) {
        String path;
        profiler.method_15396("rprenames:collecting_cem_renames");
        if (CEMParser.shouldSkipCemRenames()) {
            profiler.method_15407();
            return;
        }
        this.checked.clear();
        for (Map.Entry entry : resourceManager.method_14488(CEM_PATH, s -> {
            String path = s.method_12832();
            try {
                String fileName = path.substring(path.lastIndexOf("/") + 1, path.lastIndexOf("."));
                if (!path.endsWith(".jem")) {
                    return false;
                }
                return CEMModels.modelExists(fileName);
            }
            catch (Exception e) {
                return false;
            }
        }).entrySet()) {
            try {
                for (String jpmFileName : CEMParser.objToParamList(CEMParser.objFromInputStream(((class_3298)entry.getValue()).method_14482()), "model")) {
                    if (jpmFileName == null || !jpmFileName.endsWith(".jpm")) continue;
                    path = ((class_2960)entry.getKey()).method_12832();
                    this.parseTextureSourceFile(resourceManager, jpmFileName, path.substring(path.lastIndexOf("/") + 1, path.lastIndexOf(".")), RANDOM_ENTITY_PATH);
                }
            }
            catch (Exception e) {
                RPRenames.LOGGER.error("Something went wrong while parsing CEM Renames", (Throwable)e);
            }
        }
        for (Map.Entry entry : resourceManager.method_14488(CEM_PATH, s -> {
            String path = s.method_12832();
            try {
                String fileName = path.substring(path.lastIndexOf("/") + 1, path.lastIndexOf("."));
                if (!path.endsWith(PROP_EXTENSION)) {
                    return false;
                }
                return CEMModels.modelExists(fileName);
            }
            catch (Exception e) {
                return false;
            }
        }).entrySet()) {
            try {
                Properties p = new Properties();
                p.load(((class_3298)entry.getValue()).method_14482());
                ArrayList<String> numbers = CEMParser.getModelNumsFromProp(p);
                path = ((class_2960)entry.getKey()).method_12832();
                String pathInCem = path.substring(CEM_PATH.length() + 1, path.lastIndexOf("."));
                for (String n : numbers) {
                    if (n.equals("1")) {
                        n = "";
                    }
                    String jem = pathInCem + n + ".jem";
                    this.parseTextureSourceFile(resourceManager, jem, pathInCem.substring(pathInCem.lastIndexOf("/") + 1), MOB_PATH);
                }
            }
            catch (Exception e) {
                RPRenames.LOGGER.error("Something went wrong while parsing CEM Renames", (Throwable)e);
            }
        }
        for (CEMModels.ModelData modelData : CEMModels.data) {
            for (String texture : modelData.textures()) {
                try {
                    this.parseRawPropertyFile(resourceManager, RANDOM_ENTITY_PATH, texture, modelData.mob());
                    this.parseRawPropertyFile(resourceManager, MOB_PATH, texture, modelData.mob());
                }
                catch (Exception e) {
                    RPRenames.LOGGER.error("Something went wrong while parsing CEM Renames", (Throwable)e);
                }
            }
        }
        this.checked.clear();
        profiler.method_15407();
    }

    private void parseRawPropertyFile(class_3300 resourceManager, String texturePath, String texture, class_1299<?> entityType) throws IOException {
        class_2960 identifier = class_2960.method_60655((String)"minecraft", (String)(texturePath + texture + PROP_EXTENSION));
        Optional optionalResource = resourceManager.method_14486(identifier);
        if (optionalResource.isEmpty() && (optionalResource = resourceManager.method_14486(identifier = class_2960.method_60655((String)"minecraft", (String)(texturePath + CEMParser.getLastPathPart(texture) + PROP_EXTENSION)))).isEmpty()) {
            return;
        }
        class_3298 resource = (class_3298)optionalResource.get();
        String packName = ParserHelper.validatePackName(resource.method_45304().method_14409());
        String path = ParserHelper.getFullPathFromIdentifier(packName, identifier);
        if (this.checked.contains(path)) {
            return;
        }
        this.propertiesToRenameMob(ParserHelper.getPropFromResource(resource), packName, path, entityType);
    }

    private void parseTextureSourceFile(class_3300 resourceManager, String fileWithTextureName, String fileName, String texturePath) throws IOException {
        Optional optionalResourceJpm = resourceManager.method_14486(class_2960.method_60655((String)"minecraft", (String)("optifine/cem/" + fileWithTextureName)));
        if (optionalResourceJpm.isEmpty()) {
            return;
        }
        class_3298 resourceJpm = (class_3298)optionalResourceJpm.get();
        ArrayList<String> textures = CEMParser.objToParamList(CEMParser.objFromInputStream(resourceJpm.method_14482()), "texture");
        if (textures.isEmpty()) {
            return;
        }
        String textureName = CEMParser.prepareTexturePath(textures.getFirst());
        class_2960 propId = class_2960.method_60655((String)"minecraft", (String)(texturePath + textureName + PROP_EXTENSION));
        Optional optionalResourceProp = resourceManager.method_14486(propId);
        if (optionalResourceProp.isEmpty()) {
            return;
        }
        class_3298 resourceProp = (class_3298)optionalResourceProp.get();
        String packName = ParserHelper.validatePackName(resourceProp.method_45304().method_14409());
        String path = ParserHelper.getFullPathFromIdentifier(packName, propId);
        this.checked.add(path);
        CEMModels.ModelData modelData = CEMModels.find(fileName);
        if (modelData == null) {
            return;
        }
        this.propertiesToRenameMob(ParserHelper.getPropFromResource(resourceProp), packName, path, modelData.mob());
    }

    private void propertiesToRenameMob(Properties p, String packName, String path, class_1299<?> entityType) {
        ArrayList<String> skins = new ArrayList<String>();
        for (String s : p.stringPropertyNames()) {
            CITRename citRename;
            AbstractRename renameForItem;
            String nameIndex;
            String skin;
            if (!s.startsWith("name.") || skins.contains(skin = p.getProperty("skins." + (nameIndex = s.substring(5))))) continue;
            skins.add(skin);
            String name = PropertiesHelper.getFirstName(p.getProperty(s), path);
            if (name == null) continue;
            ArrayList<AbstractRename> alreadyExist = this.renamesManager.getRenames(CEMRename.DEFAULT_MOB_ITEM);
            CEMRename.Mob mob = new CEMRename.Mob(entityType, p, path.replaceAll("\\\\", "/"), packName, nameIndex);
            CITRename renameNameOnly = new CITRename(name, CEMRename.DEFAULT_MOB_ITEM);
            String citPackName = null;
            String citPath = null;
            Properties citProperties = null;
            int i = renameNameOnly.indexIn(alreadyExist, true);
            if (i != -1 && (renameForItem = alreadyExist.get(i)) instanceof CITRename && (citRename = (CITRename)renameForItem).same(new CITRename(name, CEMRename.DEFAULT_MOB_ITEM), false)) {
                alreadyExist.remove(i);
                citPackName = citRename.getPackName();
                citPath = citRename.getPath();
                citProperties = citRename.getProperties();
            }
            CEMRename rename = new CEMRename(name, citPackName, citPath, citProperties, mob);
            if (new CEMRename(name, mob.getEntity()).isContainedIn(alreadyExist, true)) continue;
            ArrayList<AbstractRename> newConfig = new ArrayList<AbstractRename>(alreadyExist);
            newConfig.add(rename);
            this.renamesManager.overrideRenames(CEMRename.DEFAULT_MOB_ITEM, newConfig);
        }
    }

    private static ArrayList<String> getModelNumsFromProp(Properties models) {
        ArrayList<String> numbers = new ArrayList<String>();
        try {
            for (String p : models.stringPropertyNames()) {
                String num;
                if (!p.startsWith("models.") || numbers.contains(num = models.getProperty(p))) continue;
                numbers.addAll(List.of(num.split(" ")));
            }
        }
        catch (Exception e) {
            RPRenames.LOGGER.error("Something went wrong while parsing CEM Renames", (Throwable)e);
        }
        return numbers;
    }

    private static Object objFromInputStream(InputStream inputStream) {
        Object obj = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            Type type = new TypeToken<Object>(){}.getType();
            Gson gson = new Gson();
            obj = gson.fromJson((Reader)bufferedReader, type);
            bufferedReader.close();
        }
        catch (Exception e) {
            RPRenames.LOGGER.error("Something went wrong while parsing CEM Renames", (Throwable)e);
        }
        return obj;
    }

    private static ArrayList<String> objToParamList(Object obj, String param) {
        String string = obj.toString();
        ArrayList<String> list = new ArrayList<String>();
        int j = string.length() - param.length();
        for (int i = 0; i < j; ++i) {
            if (!string.startsWith(param + "=", i) || i != 0 && String.valueOf(string.charAt(i - 1)).matches("[a-zA-Z]")) continue;
            int start = i + param.length() + 1;
            if (!string.contains(",")) continue;
            list.add(string.substring(start, string.indexOf(44, start)));
        }
        return list;
    }

    private static String getLastPathPart(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private static String prepareTexturePath(String texturePath) {
        if (texturePath.endsWith(".png")) {
            texturePath = texturePath.substring(0, texturePath.length() - 4);
        }
        if (texturePath.startsWith("textures/entity/")) {
            texturePath = texturePath.substring(16);
        }
        return texturePath;
    }

    private static boolean shouldSkipCemRenames() {
        if (ignoreSkip) {
            return true;
        }
        return ModConfig.INSTANCE.ignoreCEM;
    }
}

