/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.util.config.generation;

import com.HiWord9.RPRenames.RPRenames;
import com.HiWord9.RPRenames.util.config.PropertiesHelper;
import com.HiWord9.RPRenames.util.config.generation.Parser;
import com.HiWord9.RPRenames.util.config.generation.ParserHelper;
import com.HiWord9.RPRenames.util.rename.RenamesManager;
import com.HiWord9.RPRenames.util.rename.type.CITRename;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_7923;

public class CITParser
implements Parser {
    private static final List<String> ROOTS = List.of("mcpatcher", "optifine", "citresewn");
    public RenamesManager renamesManager;

    public CITParser(RenamesManager renamesManager) {
        this.renamesManager = renamesManager;
    }

    @Override
    public void parse(class_3300 resourceManager, class_3695 profiler) {
        profiler.method_15396("rprenames:collecting_cit_renames");
        for (String root : ROOTS) {
            for (Map.Entry entry : resourceManager.method_14488(root + "/cit", s -> s.method_12832().endsWith(".properties")).entrySet()) {
                try {
                    String packName = ParserHelper.validatePackName(((class_3298)entry.getValue()).method_45304().method_14409());
                    this.propertiesToRename(ParserHelper.getPropFromResource((class_3298)entry.getValue()), packName, ParserHelper.getFullPathFromIdentifier(packName, (class_2960)entry.getKey()));
                }
                catch (Exception e) {
                    RPRenames.LOGGER.error("Something went wrong while parsing CIT Renames", (Throwable)e);
                }
            }
        }
        profiler.method_15407();
    }

    private void propertiesToRename(Properties p, String packName, String path) {
        String enchantLvlProp;
        String firstEnchantLvl;
        String firstDamage;
        int i;
        String matchItems = p.getProperty("matchItems");
        if (matchItems == null) {
            matchItems = p.getProperty("items");
        }
        if (matchItems == null) {
            return;
        }
        while (matchItems.endsWith(" ") || matchItems.endsWith("\t")) {
            matchItems = matchItems.substring(0, matchItems.length() - 1);
        }
        ArrayList<class_1792> items = CITParser.itemsFromMatchItems(matchItems);
        if (items.isEmpty()) {
            return;
        }
        String customName = PropertiesHelper.getCustomName(p);
        if (customName == null) {
            return;
        }
        String stackSizeProp = p.getProperty("stackSize");
        String firstStackSize = PropertiesHelper.getFirstValueInList(stackSizeProp == null ? "" : stackSizeProp);
        Integer stackSize = null;
        if (!firstStackSize.isEmpty() && (i = Integer.parseInt(firstStackSize)) <= 64 && i > 0) {
            stackSize = i;
        }
        String damageProp = p.getProperty("damage");
        CITRename.Damage damage = null;
        if (damageProp != null && !(firstDamage = PropertiesHelper.getFirstValueInList(damageProp)).isEmpty()) {
            try {
                int d = Integer.parseInt(firstDamage.replace("%", ""));
                damage = new CITRename.Damage(d, firstDamage.contains("%"));
            }
            catch (NumberFormatException ignored) {
                RPRenames.LOGGER.warn("Could not get valid damage value {} for {}", (Object)firstDamage, (Object)path);
            }
        }
        String enchantIdProp = p.getProperty("enchantmentIDs");
        class_2960 enchantment = null;
        if (enchantIdProp != null) {
            String firstEnchantId = PropertiesHelper.getFirstValueInList(enchantIdProp);
            enchantment = class_2960.method_60654((String)firstEnchantId);
        }
        Integer enchantLvl = (firstEnchantLvl = PropertiesHelper.getFirstValueInList((enchantLvlProp = p.getProperty("enchantmentLevels")) == null ? "" : enchantLvlProp)).isEmpty() ? null : (Integer.parseInt(firstEnchantLvl) <= 0 ? null : Integer.valueOf(Integer.parseInt(firstEnchantLvl)));
        String description = p.getProperty("$rprenames.description");
        if (description == null) {
            description = p.getProperty("$rpr.description");
        }
        if (description == null) {
            description = p.getProperty("$description");
        }
        CITRename rename = new CITRename(PropertiesHelper.getFirstName(customName, path), items, packName, path, stackSize, damage, enchantment, enchantLvl, p, description);
        CITRename simplifiedRename = new CITRename(rename.getName(), null, null, null, rename.getStackSize(), rename.getDamage(), rename.getEnchantment(), rename.getEnchantmentLevel(), null, null);
        for (class_1792 item : items) {
            if (simplifiedRename.isContainedIn(this.renamesManager.getRenames(item), true)) continue;
            this.renamesManager.addRename(item, rename);
        }
    }

    private static ArrayList<String> splitMatchItems(String matchItems) {
        ArrayList<String> items = new ArrayList<String>();
        int start = 0;
        while (start <= matchItems.length()) {
            String item = PropertiesHelper.getFirstValueInList(matchItems.substring(start));
            start += item.length() + 1;
            if (item.startsWith("minecraft:")) {
                item = item.substring(10);
            }
            if (item.equals("air")) continue;
            items.add(item);
        }
        return items;
    }

    private static ArrayList<class_1792> itemsFromMatchList(ArrayList<String> matchItemsList) {
        ArrayList<class_1792> items = new ArrayList<class_1792>();
        for (String matchItem : matchItemsList) {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)matchItem));
            if (item == class_1802.field_8162) continue;
            items.add(item);
        }
        return items;
    }

    private static ArrayList<class_1792> itemsFromMatchItems(String matchItems) {
        return CITParser.itemsFromMatchList(CITParser.splitMatchItems(matchItems));
    }
}

