/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.util.gui.widget;

import com.HiWord9.RPRenames.modConfig.ModConfig;
import com.HiWord9.RPRenames.util.RPRInteractableScreen;
import com.HiWord9.RPRenames.util.config.favorite.FavoritesManager;
import com.HiWord9.RPRenames.util.gui.Graphics;
import com.HiWord9.RPRenames.util.gui.widget.GhostCraft;
import com.HiWord9.RPRenames.util.gui.widget.button.PageButton;
import com.HiWord9.RPRenames.util.gui.widget.button.RandomButton;
import com.HiWord9.RPRenames.util.gui.widget.button.RenameButton;
import com.HiWord9.RPRenames.util.gui.widget.button.TabButton;
import com.HiWord9.RPRenames.util.gui.widget.button.external.FavoriteButton;
import com.HiWord9.RPRenames.util.gui.widget.button.external.OpenerButton;
import com.HiWord9.RPRenames.util.rename.RenamesHelper;
import com.HiWord9.RPRenames.util.rename.RenamesManager;
import com.HiWord9.RPRenames.util.rename.type.AbstractRename;
import com.HiWord9.RPRenames.util.rename.type.CITRename;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_8021;
import org.jetbrains.annotations.Nullable;

public class RPRWidget
implements class_4068,
class_364 {
    protected ModConfig config = ModConfig.INSTANCE;
    protected static class_2960 MENU_TEXTURE = class_2960.method_60655((String)"rprenames", (String)"textures/gui/menu.png");
    public static final int MENU_TEXTURE_WIDTH = 147;
    public static final int MENU_TEXTURE_HEIGHT = 166;
    public static final int WIDGET_WIDTH = 177;
    public static final int WIDGET_HEIGHT = 166;
    static int MENU_START_X = 30;
    static final int TAB_OFFSET_Y = 6;
    static final int START_TAB_OFFSET_Y = 6;
    static final int BUTTON_X_OFFSET = 10;
    static final int SEARCH_FIELD_X_OFFSET = 24;
    static final int PAGE_BUTTONS_Y = 136;
    class_310 client;
    RPRInteractableScreen interactableScreen;
    RenamesManager renamesManager;
    FavoritesManager favoritesManager;
    class_342 nameField;
    OpenerButton openerButton;
    FavoriteButton favoriteButton;
    GhostCraft ghostCraft;
    int x;
    int y;
    public boolean init = false;
    boolean open;
    TabButton searchTab;
    TabButton favoriteTab;
    TabButton inventoryTab;
    TabButton globalTab;
    RandomButton randomButton;
    public class_342 searchField;
    PageButton pageDown;
    PageButton pageUp;
    public ArrayList<class_339> widgets = new ArrayList();
    class_2561 pageCount = class_2561.method_43473();
    final ArrayList<RenameButton> buttons = new ArrayList();
    Tab currentTab = Tab.SEARCH;
    ArrayList<AbstractRename> originalRenameList = new ArrayList();
    ArrayList<AbstractRename> currentRenameList = new ArrayList();
    final class_327 renderer;
    final class_2561 SEARCH_HINT_TEXT;
    String searchTag;
    int page;
    int rows;
    int columns;
    int maxPageElements;
    class_1799 currentItem;
    public boolean shouldNotUpdateTab;
    int tempPage;
    ArrayList<class_1792> inventory;

    public RPRWidget() {
        this.renderer = class_310.method_1551().field_1772;
        this.SEARCH_HINT_TEXT = class_2561.method_43471((String)"rprenames.gui.searchHintText").method_27692(class_124.field_1056).method_27692(class_124.field_1080);
        this.searchTag = "";
        this.page = 0;
        this.rows = 4;
        this.columns = 5;
        this.maxPageElements = this.rows * this.columns;
        this.currentItem = class_1799.field_8037;
        this.shouldNotUpdateTab = false;
        this.inventory = new ArrayList();
    }

    public void init(int x, int y, @Nullable RPRInteractableScreen parentScreen, RenamesManager renamesManager, FavoritesManager favoritesManager, class_342 nameField, OpenerButton openerButton, FavoriteButton favoriteButton, GhostCraft ghostCraft) {
        this.init = true;
        this.client = class_310.method_1551();
        this.renamesManager = renamesManager;
        this.favoritesManager = favoritesManager;
        this.nameField = nameField;
        this.openerButton = openerButton;
        this.favoriteButton = favoriteButton;
        this.ghostCraft = ghostCraft;
        this.interactableScreen = parentScreen;
        this.x = x;
        this.y = y;
        this.pageDown = new PageButton(this, this.x + MENU_START_X + 10, this.y + 136, PageButton.Type.DOWN);
        this.pageUp = new PageButton(this, this.x + 177 - 10 - 30, this.y + 136, PageButton.Type.UP);
        this.searchTab = new TabButton(this, this.x, this.y + 6, Tab.SEARCH);
        this.favoriteTab = new TabButton(this, this.x, this.y + 6 + 32, Tab.FAVORITE);
        this.inventoryTab = new TabButton(this, this.x, this.y + 6 + 64, Tab.INVENTORY);
        this.globalTab = new TabButton(this, this.x, this.y + 6 + 128, Tab.GLOBAL);
        this.randomButton = new RandomButton(this, this.x + 177 - 14 - 9, this.y + 14, this.randomNumber() % 6);
        this.searchField = new class_342(this.renderer, this.x + MENU_START_X + 24, this.y + 15, 94, 10, class_2561.method_30163((String)""));
        this.searchField.method_1863(this::onSearch);
        this.searchField.method_1858(false);
        this.searchField.method_1880(1024);
        this.widgets = new ArrayList<class_342>(List.of(this.searchTab, this.favoriteTab, this.inventoryTab, this.globalTab, this.pageDown, this.pageUp, this.randomButton, this.searchField));
        this.updateFavoriteButton();
        this.screenUpdate();
    }

    public boolean isOpen() {
        return this.open;
    }

    public void toggleOpen() {
        if (!this.open) {
            this.open();
        } else {
            this.close();
        }
        this.interactableScreen.updateMenuShift();
    }

    public void open() {
        this.open = true;
        this.currentTab = this.currentItem.method_7960() ? Tab.GLOBAL : Tab.SEARCH;
        this.screenUpdate();
        this.nameField.method_25365(false);
        this.nameField.method_1856(true);
    }

    public void close() {
        this.open = false;
        this.searchField.method_25365(false);
        this.searchField.method_1856(false);
        this.searchField.method_1852("");
        this.updateWidgets();
        this.currentTab = Tab.SEARCH;
        this.nameField.method_25365(true);
        this.nameField.method_1856(false);
    }

    public String getNameText() {
        return this.nameField.method_1882();
    }

    public void setNameText(String text) {
        this.nameField.method_1852(text);
    }

    public void setTab(Tab tab) {
        if (tab == this.currentTab) {
            return;
        }
        this.currentTab = tab;
        this.screenUpdate();
    }

    public Tab getCurrentTab() {
        return this.currentTab;
    }

    public void setPage(int page) {
        this.page = page;
        this.updateWidgets();
    }

    public int getPage() {
        return this.page;
    }

    public void prevPage() {
        this.setPage(class_437.method_25442() ? 0 : this.page - 1);
    }

    public void nextPage() {
        this.setPage(class_437.method_25442() ? (this.currentRenameList.size() + this.maxPageElements - 1) / this.maxPageElements - 1 : this.page + 1);
    }

    public class_1799 getCurrentItem() {
        return this.currentItem;
    }

    public class_1792 getItemInFirstSlot() {
        class_1792 item = this.currentItem.method_7909();
        if (item == class_1802.field_8162 && !this.ghostCraft.getStackInFirstSlot().method_7960()) {
            item = this.ghostCraft.getStackInFirstSlot().method_7909();
        }
        return item;
    }

    public void addOrRemoveFavorite(boolean add) {
        this.addOrRemoveFavorite(add, this.getNameText(), this.getItemInFirstSlot());
    }

    public void addOrRemoveFavorite(boolean add, String favoriteName, class_1792 item) {
        if (item != class_1802.field_8162) {
            if (add) {
                this.favoritesManager.addRename(item, favoriteName);
            } else {
                this.favoritesManager.removeRename(item, favoriteName);
            }
            this.updateAfterFavorite();
        }
    }

    public void updateAfterFavorite() {
        this.updateFavoriteButton();
        if (this.isOpen()) {
            if (this.currentTab == Tab.FAVORITE) {
                this.screenUpdate(this.getPage());
            } else {
                this.updateWidgets();
            }
        }
    }

    public void onRenameButton(int button, boolean favorite, AbstractRename rename) {
        boolean isInInventory;
        class_1792 item = this.firstItemInInventory(rename);
        boolean asCurrentItem = item == this.getItemInFirstSlot();
        int indexInInventory = this.inventory.indexOf(item);
        boolean bl = isInInventory = indexInInventory != -1;
        if (button == 1 && rename.getItem() != null) {
            this.favoriteInGui(favorite, rename, asCurrentItem, isInInventory, indexInInventory);
            return;
        }
        this.executeRename(rename, isInInventory, indexInInventory, asCurrentItem);
    }

    private void executeRename(AbstractRename rename, boolean isInInventory, int indexInInventory, boolean asCurrentItem) {
        this.ghostCraft.reset();
        if (isInInventory) {
            if (indexInInventory != 36) {
                this.shouldNotUpdateTab = this.getCurrentTab() == Tab.INVENTORY || this.getCurrentTab() == Tab.GLOBAL;
                this.tempPage = this.page;
                if (!asCurrentItem) {
                    this.interactableScreen.moveToCraft(indexInInventory, 0);
                }
                this.shouldNotUpdateTab = false;
            } else {
                this.interactableScreen.moveToInventory(1);
            }
            if (rename instanceof CITRename) {
                CITRename citRename = (CITRename)rename;
                CITRename.CraftMatcher craftMatcher = new CITRename.CraftMatcher(citRename, this.currentItem);
                if (!craftMatcher.enoughStackSize() || !craftMatcher.enoughDamage()) {
                    this.ghostCraft.setSpecialHighlight(true, null, true);
                    this.ghostCraft.setRender(true);
                }
                if (!craftMatcher.hasEnchant() || !craftMatcher.hasEnoughLevels()) {
                    this.ghostCraft.setStacks(class_1799.field_8037, RenamesHelper.getGhostCraftEnchant(citRename), class_1799.field_8037);
                    this.ghostCraft.setSpecialHighlight(null, null, true);
                    this.ghostCraft.setRender(true);
                }
            }
        } else {
            for (int s = 0; s < 2; ++s) {
                this.interactableScreen.moveToInventory(s);
            }
            class_1799[] ghostCraftStacks = RenamesHelper.getGhostCraftItems(rename);
            this.ghostCraft.setStacks(ghostCraftStacks[0], ghostCraftStacks[1], ghostCraftStacks[2]);
            this.ghostCraft.setRender(true);
        }
        this.setNameText(rename.getName());
    }

    private void favoriteInGui(boolean favorite, AbstractRename rename, boolean asCurrentItem, boolean isInInventory, int indexInInventory) {
        if (this.getCurrentTab() == Tab.SEARCH || this.getCurrentTab() == Tab.FAVORITE || asCurrentItem) {
            this.addOrRemoveFavorite(!favorite, rename.getName(), this.getItemInFirstSlot());
        } else if (favorite) {
            for (class_1792 i : rename.getItems()) {
                if (!this.favoritesManager.isFavorite(i, rename.getName())) continue;
                this.favoritesManager.removeRename(i, rename.getName());
            }
            this.updateAfterFavorite();
        } else {
            this.addOrRemoveFavorite(true, rename.getName(), isInInventory ? this.inventory.get(indexInInventory) : rename.getItem());
        }
    }

    public void chooseRandomRename() {
        int randomNumber = this.randomNumber();
        int randomSide = randomNumber % 6;
        this.randomButton.setSide(randomSide);
        if (this.currentRenameList.isEmpty()) {
            return;
        }
        int renameNumber = randomNumber % this.currentRenameList.size();
        this.setPage(renameNumber / this.maxPageElements);
        this.buttons.get(renameNumber % this.maxPageElements).execute(0);
    }

    public void screenUpdate() {
        this.screenUpdate(0);
    }

    public void screenUpdate(int savedPage) {
        this.page = savedPage;
        if (this.shouldNotUpdateTab) {
            this.page = this.tempPage;
        }
        this.calcRenameList();
        if (this.open) {
            this.updateSearchRequest(this.page);
            this.searchField.method_1856(true);
        }
    }

    public void updateName() {
        this.updateFavoriteButton();
        this.updateSelected();
    }

    public void itemUpdate(int slotId, class_1799 stack) {
        if (slotId == 0) {
            this.currentItem = stack.method_7972();
            if (stack.method_7960()) {
                class_437 screen = this.client.field_1755;
                if (screen != null && screen.method_25399() == this.searchField) {
                    screen.method_25395(null);
                }
                this.searchField.method_25365(false);
            } else if (!this.shouldNotUpdateTab) {
                this.currentTab = Tab.SEARCH;
            }
            if (!this.open || this.currentTab != Tab.GLOBAL) {
                this.screenUpdate();
            } else {
                this.updateSearchRequest(this.page);
            }
            this.updateFavoriteButton();
        }
        if (slotId == 0 || slotId == 1) {
            this.ghostCraft.reset();
            if (this.currentItem.method_7960()) {
                this.setNameText("");
            }
        }
    }

    public void offsetX(int x) {
        this.x += x;
        for (class_8021 class_80212 : this.widgets) {
            class_80212.method_46421(class_80212.method_46426() + x);
        }
        for (RenameButton renameButton : this.buttons) {
            if (renameButton == null) continue;
            renameButton.method_46421(renameButton.method_46426() + x);
        }
    }

    private void checkForInvChanges() {
        if (this.inventory.isEmpty()) {
            this.inventory = this.getInventory();
            return;
        }
        ArrayList<class_1792> temp = this.getInventory();
        boolean equal = true;
        if (temp.size() != this.inventory.size()) {
            equal = false;
        } else {
            for (int i = 0; i < temp.size(); ++i) {
                if (this.inventory.get(i).equals(temp.get(i))) continue;
                equal = false;
                break;
            }
        }
        if (equal) {
            return;
        }
        this.inventory = temp;
        this.screenUpdate(this.page);
    }

    public ArrayList<class_1792> getInventory() {
        ArrayList<class_1792> inventoryList = new ArrayList<class_1792>();
        assert (class_310.method_1551().field_1724 != null);
        class_1661 inventory = class_310.method_1551().field_1724.method_31548();
        for (class_1799 itemStack : inventory.field_7547) {
            inventoryList.add(itemStack.method_7909());
        }
        inventoryList.add(this.currentItem.method_7909());
        return inventoryList;
    }

    private int randomNumber() {
        assert (this.client != null && this.client.field_1724 != null);
        return this.client.field_1724.method_59922().method_39332(0, 0x7FFFFFFE);
    }

    public class_1792 firstItemInInventory(AbstractRename rename) {
        class_1792 item;
        if (this.currentTab == Tab.SEARCH) {
            item = this.getItemInFirstSlot();
        } else {
            item = rename.getItem();
            for (class_1792 i : rename.getItems()) {
                if (!this.inventory.contains(i)) continue;
                item = i;
                break;
            }
        }
        return item;
    }

    private void updateFavoriteButton() {
        this.updateFavoriteButton(this.getNameText());
    }

    private void updateFavoriteButton(String name) {
        this.updateFavoriteButton(name, this.getItemInFirstSlot());
    }

    private void updateFavoriteButton(String name, class_1792 item) {
        if (!name.isEmpty()) {
            this.favoriteButton.field_22763 = true;
            boolean favorite = this.favoritesManager.isFavorite(item, name);
            this.favoriteButton.setFavorite(favorite);
        } else {
            this.favoriteButton.field_22763 = false;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.open) {
            this.searchField.method_25365(false);
            return;
        }
        this.checkForInvChanges();
        RenderSystem.enableDepthTest();
        context.method_25291(MENU_TEXTURE, this.x + MENU_START_X, this.y, 0, 0.0f, 0.0f, 147, 166, 147, 166);
        if (this.searchField != null && !this.searchField.method_25370() && this.searchField.method_1882().isEmpty()) {
            Graphics.renderText(context, this.SEARCH_HINT_TEXT, -1, this.x + MENU_START_X + 24, this.y + 15, true, false);
        }
        if (this.currentRenameList.isEmpty()) {
            String key = this.getItemInFirstSlot() == class_1802.field_8162 && (this.currentTab == Tab.FAVORITE || this.currentTab == Tab.SEARCH) ? "putItem" : (this.currentTab == Tab.FAVORITE ? "noFavoriteRenamesFound" : "noRenamesFound");
            Graphics.renderText(context, (class_2561)class_2561.method_43471((String)("rprenames.gui." + key)).method_27661().method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080)), -1, this.x + MENU_START_X + 73, this.y + 37, true, true);
        } else {
            Graphics.renderText(context, this.pageCount, this.x + MENU_START_X + 73, this.y + 140, false, true);
        }
        for (RenameButton renameButton : this.buttons) {
            renameButton.method_25394(context, mouseX, mouseY, 0.0f);
        }
        for (class_4068 class_40682 : this.widgets) {
            class_40682.method_25394(context, mouseX, mouseY, 0.0f);
        }
        for (RenameButton renameButton : this.buttons) {
            renameButton.postRender(context, mouseX, mouseY);
        }
        RenderSystem.disableDepthTest();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.open) {
            class_437 screen = this.client.field_1755;
            for (class_364 class_3642 : this.widgets) {
                if (class_3642.method_25402(mouseX, mouseY, button)) {
                    if (class_3642 == this.searchField && screen != null) {
                        screen.method_25395((class_364)this.searchField);
                    }
                    return true;
                }
                if (class_3642 != this.searchField || screen == null || screen.method_25399() != this.searchField) continue;
                screen.method_25395(null);
            }
            for (RenameButton renameButton : this.buttons) {
                if (!renameButton.method_25402(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (class_364 class_3642 : this.widgets) {
            if (!class_3642.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }

    private void calcRenameList() {
        switch (this.currentTab.ordinal()) {
            case 0: {
                this.originalRenameList = this.renamesManager.getRenames(this.getItemInFirstSlot());
                break;
            }
            case 1: {
                this.originalRenameList = this.favoritesManager.getRenames(this.getItemInFirstSlot());
                break;
            }
            case 2: {
                ArrayList<class_1792> checked = new ArrayList<class_1792>();
                ArrayList<AbstractRename> names = new ArrayList<AbstractRename>();
                for (class_1792 item : this.inventory) {
                    if (item == class_1802.field_8162 || checked.contains(item)) continue;
                    checked.add(item);
                    ArrayList<AbstractRename> renames = this.renamesManager.getRenames(item);
                    for (AbstractRename r : renames) {
                        if (names.contains(r)) continue;
                        names.add(r);
                    }
                }
                this.originalRenameList = names;
                break;
            }
            case 3: {
                this.originalRenameList = this.renamesManager.getAllRenames();
            }
        }
    }

    private void updateSearchRequest() {
        this.updateSearchRequest(0);
    }

    private void updateSearchRequest(int page) {
        this.currentRenameList = RenamesHelper.search(this.originalRenameList, this.searchTag, this.favoritesManager);
        this.page = page;
        if (this.page >= (this.currentRenameList.size() + this.maxPageElements - 1) / this.maxPageElements) {
            this.page = (this.currentRenameList.size() + this.maxPageElements - 1) / this.maxPageElements - 1;
            if (this.page == -1) {
                this.page = 0;
            }
        }
        this.updateWidgets();
    }

    private RenameButton createButton(int orderOnPage, AbstractRename rename) {
        boolean favorite = false;
        if (this.currentTab != Tab.SEARCH) {
            for (class_1792 i : rename.getItems()) {
                if (!this.favoritesManager.isFavorite(i, rename.getName())) continue;
                favorite = true;
                break;
            }
        } else {
            favorite = this.favoritesManager.isFavorite(this.getItemInFirstSlot(), rename.getName());
        }
        int buttonX = this.x + MENU_START_X + 10;
        int buttonY = this.y + 30;
        int x = buttonX + 1 + orderOnPage % 5 * 25;
        int y = buttonY + 1 + orderOnPage / 5 * 25;
        return new RenameButton(this, rename, x, y, favorite);
    }

    private void updateWidgets() {
        this.updateButtons();
        this.updateSelected();
        this.updatePageWidgets();
    }

    private void updateButtons() {
        this.buttons.clear();
        for (int n = 0; n < this.maxPageElements; ++n) {
            if (n + this.page * this.maxPageElements > this.currentRenameList.size() - 1) continue;
            this.buttons.add(this.createButton(n, this.currentRenameList.get(n + this.page * this.maxPageElements)));
        }
    }

    private void updateSelected() {
        for (RenameButton button : this.buttons) {
            if (button == null) continue;
            button.setSelected(button.rename.getItems().contains(this.getItemInFirstSlot()) && button.rename.getName().equals(this.getNameText()));
        }
    }

    private void updatePageWidgets() {
        this.pageDown.field_22763 = this.page > 0;
        this.pageUp.field_22763 = (this.page + 1) * this.maxPageElements <= this.currentRenameList.size() - 1;
        this.pageCount = class_2561.method_30163((String)(this.page + 1 + "/" + (this.currentRenameList.size() + this.maxPageElements - 1) / this.maxPageElements));
    }

    private void onSearch(String search) {
        this.searchTag = search;
        if (this.open) {
            this.updateSearchRequest();
        }
    }

    public static enum Tab {
        SEARCH,
        FAVORITE,
        INVENTORY,
        GLOBAL;

    }
}

