/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.util.rename.renderer;

import com.HiWord9.RPRenames.modConfig.ModConfig;
import com.HiWord9.RPRenames.util.gui.Graphics;
import com.HiWord9.RPRenames.util.gui.tooltipcomponent.MultiItemTooltipComponent;
import com.HiWord9.RPRenames.util.gui.tooltipcomponent.preview.ItemPreviewTooltipComponent;
import com.HiWord9.RPRenames.util.gui.tooltipcomponent.preview.PlayerPreviewTooltipComponent;
import com.HiWord9.RPRenames.util.gui.widget.RPRWidget;
import com.HiWord9.RPRenames.util.rename.renderer.DefaultRenameRenderer;
import com.HiWord9.RPRenames.util.rename.renderer.PreviewTooltipPositioner;
import com.HiWord9.RPRenames.util.rename.renderer.RenameRenderer;
import com.HiWord9.RPRenames.util.rename.type.CITRename;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8000;

public class CITRenameRenderer
extends DefaultRenameRenderer<CITRename>
implements RenameRenderer.Preview {
    private static final ModConfig config = ModConfig.INSTANCE;
    private static final class_5250 playerPreviewHintShift = class_2561.method_43469((String)"rprenames.gui.tooltipHint.playerPreview.holdShift", (Object[])new Object[]{class_2561.method_43471((String)"rprenames.key.shift").method_27692(class_124.field_1080)}).method_27692(class_124.field_1063);
    private static final class_5250 playerPreviewHintF = class_2561.method_43469((String)"rprenames.gui.tooltipHint.playerPreview.pressF", (Object[])new Object[]{class_2561.method_43471((String)"rprenames.key.f").method_27692(class_124.field_1080)}).method_27692(class_124.field_1063);
    private static final class_5250 favoriteHintAdd = class_2561.method_43469((String)"rprenames.gui.tooltipHint.favorite.add", (Object[])new Object[]{class_2561.method_43471((String)"rprenames.key.rmb").method_27692(class_124.field_1080)}).method_27692(class_124.field_1063);
    private static final class_5250 favoriteHintRemove = class_2561.method_43469((String)"rprenames.gui.tooltipHint.favorite.remove", (Object[])new Object[]{class_2561.method_43471((String)"rprenames.key.rmb").method_27692(class_124.field_1080)}).method_27692(class_124.field_1063);
    private static final class_5250 disableHint = class_2561.method_43469((String)"rprenames.gui.tooltipHint.disable", (Object[])new Object[]{class_2561.method_43471((String)"rprenames.gui.tooltipHint.disable.command").method_27692(class_124.field_1061)}).method_27692(class_124.field_1079);
    RPRWidget rprWidget;
    boolean favorite;
    ItemPreviewTooltipComponent itemPreviewTooltipComponent;
    PlayerPreviewTooltipComponent playerPreviewTooltipComponent;
    private boolean fPressFuse = false;

    public CITRenameRenderer(CITRename rename, RPRWidget rprWidget, boolean favorite) {
        super(rename);
        class_5684 pattern;
        this.rprWidget = rprWidget;
        this.favorite = favorite;
        int width = 42;
        int height = 42;
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        int playerSize = (int)(32.0 * CITRenameRenderer.config.scaleFactorEntity);
        int playerWidth = (int)((float)width + (float)playerSize * client.field_1724.method_17681() - 1.0f);
        int playerHeight = (int)((float)height + (float)playerSize * client.field_1724.method_17682() - 1.0f);
        this.playerPreviewTooltipComponent = new PlayerPreviewTooltipComponent(client.field_1724, this.stack, playerWidth, playerHeight, playerSize, CITRenameRenderer.config.spinPlayerPreview);
        double scaleFactorItem = CITRenameRenderer.config.scaleFactorItem;
        int itemSize = (int)(16.0 * scaleFactorItem);
        int itemWidth = (int)((double)(width / 2) * scaleFactorItem);
        int itemHeight = (int)((double)(height / 2) * scaleFactorItem);
        this.itemPreviewTooltipComponent = new ItemPreviewTooltipComponent(this.stack, itemWidth, itemHeight, itemSize);
        int index = 1;
        if (CITRenameRenderer.config.showDescription) {
            ArrayList<class_5684> description = CITRenameRenderer.descriptionTooltipsComponentsList(rename);
            this.tooltipComponents.addAll(index, description);
            index += description.size();
        }
        if (rprWidget.getCurrentTab() == RPRWidget.Tab.INVENTORY || rprWidget.getCurrentTab() == RPRWidget.Tab.GLOBAL) {
            MultiItemTooltipComponent component = CITRenameRenderer.multiItemTooltipComponent(rprWidget, rename);
            this.tooltipComponents.add(index++, component);
        }
        if (CITRenameRenderer.config.showExtraProperties) {
            ArrayList<class_5684> extraProperties = CITRenameRenderer.extraPropertiesTooltipComponentsList(rprWidget, rename, CITRenameRenderer.config.showOriginalProperties);
            this.tooltipComponents.addAll(index, extraProperties);
            index += extraProperties.size();
        }
        if (!CITRenameRenderer.config.showPackName && rename.getPackName() != null) {
            this.tooltipComponents.remove(index);
        }
        if (CITRenameRenderer.config.showNamePattern && rprWidget.getCurrentTab() != RPRWidget.Tab.FAVORITE && (pattern = CITRenameRenderer.namePatternTooltipComponent(rename)) != null) {
            this.tooltipComponents.add(pattern);
        }
    }

    public static ArrayList<class_5684> extraPropertiesTooltipComponentsList(RPRWidget rprWidget, CITRename citRename, boolean asOriginal) {
        ArrayList<class_5250> extraProperties = new ArrayList<class_5250>();
        class_1792 item = rprWidget.firstItemInInventory(citRename);
        boolean asCurrentItem = item == rprWidget.getItemInFirstSlot();
        int indexInInventory = rprWidget.getInventory().indexOf(item);
        class_1799 stack = CITRenameRenderer.getItemStackForStack(rprWidget, indexInInventory, asCurrentItem);
        CITRename.CraftMatcher craftMatcher = new CITRename.CraftMatcher(citRename, stack);
        if (asOriginal) {
            if (citRename.getStackSize() > 1) {
                extraProperties.add(class_2561.method_30163((String)"stackSize").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)class_2561.method_30163((String)"=").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_30163((String)citRename.getOriginalStackSize()).method_27661().method_27696(class_2583.field_24360.method_10977(craftMatcher.enoughStackSize() ? class_124.field_1060 : class_124.field_1079))));
            }
            if (citRename.getDamage() != null && citRename.getDamage().damage > 0) {
                extraProperties.add(class_2561.method_30163((String)"damage").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)class_2561.method_30163((String)"=").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_30163((String)citRename.getOriginalDamage()).method_27661().method_27696(class_2583.field_24360.method_10977(craftMatcher.enoughDamage() ? class_124.field_1060 : class_124.field_1079))));
            }
            if (citRename.getEnchantment() != null) {
                extraProperties.add(class_2561.method_30163((String)"enchantmentIDs").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)class_2561.method_30163((String)"=").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_30163((String)citRename.getOriginalEnchantment()).method_27661().method_27696(class_2583.field_24360.method_10977(craftMatcher.hasEnchant() ? class_124.field_1060 : class_124.field_1079))));
                if (citRename.getOriginalEnchantmentLevel() != null) {
                    extraProperties.add(class_2561.method_30163((String)"enchantmentLevels").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)class_2561.method_30163((String)"=").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_30163((String)citRename.getOriginalEnchantmentLevel()).method_27661().method_27696(class_2583.field_24360.method_10977(craftMatcher.hasEnchant() ? class_124.field_1060 : class_124.field_1079))));
                }
            }
        } else {
            if (citRename.getStackSize() > 1) {
                extraProperties.add(class_2561.method_30163((String)(class_2561.method_43471((String)"rprenames.gui.tooltipHint.stackSize").getString() + " " + citRename.getStackSize())).method_27661().method_27696(class_2583.field_24360.method_10977(craftMatcher.enoughStackSize() ? class_124.field_1080 : class_124.field_1079)));
            }
            if (citRename.getDamage() != null && citRename.getDamage().damage > 0) {
                extraProperties.add(class_2561.method_30163((String)(class_2561.method_43471((String)"rprenames.gui.tooltipHint.damage").getString() + " " + citRename.getDamage().damage + (citRename.getDamage().percent ? "%" : ""))).method_27661().method_27696(class_2583.field_24360.method_10977(craftMatcher.enoughDamage() ? class_124.field_1080 : class_124.field_1079)));
            }
            if (citRename.getEnchantment() != null) {
                class_2960 enchant = citRename.getEnchantment();
                String namespace = enchant.method_12836();
                String string = enchant.method_12832();
                class_5250 translatedEnchant = class_2561.method_43471((String)("enchantment." + namespace + "." + string));
                class_5250 translatedEnchantLevel = class_2561.method_43471((String)("enchantment.level." + citRename.getEnchantmentLevel()));
                extraProperties.add(class_2561.method_30163((String)(class_2561.method_43471((String)"rprenames.gui.tooltipHint.enchantment").getString() + " " + translatedEnchant.getString() + " " + translatedEnchantLevel.getString())).method_27661().method_27696(class_2583.field_24360.method_10977(craftMatcher.hasEnchant() && craftMatcher.hasEnoughLevels() ? class_124.field_1080 : class_124.field_1079)));
            }
        }
        ArrayList<class_5684> propertiesComponents = new ArrayList<class_5684>();
        for (class_2561 class_25612 : extraProperties) {
            propertiesComponents.add(class_5684.method_32662((class_5481)class_25612.method_30937()));
        }
        return propertiesComponents;
    }

    private static class_1799 getItemStackForStack(RPRWidget rprWidget, int indexInInventory, boolean asCurrentItem) {
        boolean isInInventory = indexInInventory != -1;
        class_1799 stack = rprWidget.getCurrentItem();
        if ((rprWidget.getCurrentTab() == RPRWidget.Tab.INVENTORY || rprWidget.getCurrentTab() == RPRWidget.Tab.GLOBAL) && !asCurrentItem && isInInventory) {
            assert (class_310.method_1551().field_1724 != null);
            class_1661 playerInventory = class_310.method_1551().field_1724.method_31548();
            stack = (class_1799)playerInventory.field_7547.get(indexInInventory);
        }
        return stack;
    }

    @Override
    public void onRenderTooltip(class_332 context, int mouseX, int mouseY, int buttonX, int buttonY, int buttonWidth, int buttonHeight) {
        ArrayList<class_5684> tooltipAddition = new ArrayList<class_5684>();
        if (CITRenameRenderer.config.enablePreview) {
            if (!class_437.method_25442() && !CITRenameRenderer.config.playerPreviewByDefault) {
                if (!CITRenameRenderer.config.disableTooltipHints) {
                    tooltipAddition.add(this.tooltipOf(playerPreviewHintShift));
                }
            } else if (class_437.method_25442() != CITRenameRenderer.config.playerPreviewByDefault) {
                class_437 screen;
                if (!CITRenameRenderer.config.disableTooltipHints) {
                    tooltipAddition.add(this.tooltipOf(playerPreviewHintF));
                }
                if ((screen = class_310.method_1551().field_1755) != null) {
                    screen.method_25395(null);
                }
            }
        }
        if (!CITRenameRenderer.config.disableTooltipHints) {
            tooltipAddition.add(this.favorite ? this.tooltipOf(favoriteHintRemove) : this.tooltipOf(favoriteHintAdd));
            tooltipAddition.add(this.tooltipOf(disableHint));
        }
        this.tooltipComponents.addAll(tooltipAddition);
        super.onRenderTooltip(context, mouseX, mouseY, buttonX, buttonY, buttonWidth, buttonHeight);
        if (CITRenameRenderer.config.enablePreview) {
            this.drawPreview(context, mouseX, mouseY, this.tooltipComponents);
        }
        this.tooltipComponents.removeAll(tooltipAddition);
    }

    @Override
    public void drawPreview(class_332 context, int mouseX, int mouseY, ArrayList<class_5684> mainTooltip) {
        boolean shouldPreviewPlayer = class_437.method_25442() != CITRenameRenderer.config.playerPreviewByDefault;
        PreviewTooltipPositioner positioner = new PreviewTooltipPositioner(mainTooltip);
        if (shouldPreviewPlayer) {
            this.playerPreview(context, mouseX, mouseY, positioner);
        } else {
            this.itemPreview(context, mouseX, mouseY, positioner);
        }
    }

    private void playerPreview(class_332 context, int mouseX, int mouseY, class_8000 positioner) {
        if (this.isFKeyJustPressed()) {
            this.playerPreviewTooltipComponent.cycleSlots(CITRenameRenderer.config.alwaysAllowPlayerPreviewHead);
        }
        Graphics.drawTooltipWithFixedBorders(context, class_310.method_1551().field_1772, this.playerPreviewTooltipComponent, mouseX, mouseY, positioner, this.favorite);
    }

    private void itemPreview(class_332 context, int mouseX, int mouseY, class_8000 positioner) {
        Graphics.drawTooltipWithFixedBorders(context, class_310.method_1551().field_1772, this.itemPreviewTooltipComponent, mouseX, mouseY, positioner, this.favorite);
    }

    private boolean isFKeyJustPressed() {
        if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)70)) {
            if (!this.fPressFuse) {
                this.fPressFuse = true;
                return true;
            }
        } else {
            this.fPressFuse = false;
        }
        return false;
    }

    private class_5684 tooltipOf(class_5250 mutableText) {
        return class_5684.method_32662((class_5481)mutableText.method_30937());
    }
}

