/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.util.rename.renderer;

import com.HiWord9.RPRenames.util.config.PropertiesHelper;
import com.HiWord9.RPRenames.util.gui.Graphics;
import com.HiWord9.RPRenames.util.gui.tooltipcomponent.MultiItemTooltipComponent;
import com.HiWord9.RPRenames.util.gui.widget.RPRWidget;
import com.HiWord9.RPRenames.util.rename.renderer.RenameRenderer;
import com.HiWord9.RPRenames.util.rename.type.AbstractRename;
import com.HiWord9.RPRenames.util.rename.type.Describable;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8001;
import net.minecraft.class_9334;

public class DefaultRenameRenderer<T extends AbstractRename>
implements RenameRenderer {
    T rename;
    class_1799 stack;
    ArrayList<class_5684> tooltipComponents = new ArrayList();

    public DefaultRenameRenderer(T rename) {
        this.rename = rename;
        this.stack = ((AbstractRename)rename).toStack();
        this.tooltipComponents.add(this.nameTooltipComponent());
        if (this.getDisplayPackName() != null) {
            this.tooltipComponents.add(this.packNameTooltipComponent());
        }
    }

    public class_5684 nameTooltipComponent() {
        return class_5684.method_32662((class_5481)class_2561.method_30163((String)this.getDisplayName()).method_30937());
    }

    public static MultiItemTooltipComponent multiItemTooltipComponent(AbstractRename rename) {
        ArrayList<MultiItemTooltipComponent.TooltipItem> tooltipItems = new ArrayList<MultiItemTooltipComponent.TooltipItem>();
        for (int i = 0; i < rename.getItems().size(); ++i) {
            class_1799 itemStack = rename.toStack(i);
            itemStack.method_57381(class_9334.field_49631);
            tooltipItems.add(new MultiItemTooltipComponent.TooltipItem(itemStack, null));
        }
        return new MultiItemTooltipComponent(tooltipItems);
    }

    public static MultiItemTooltipComponent multiItemTooltipComponent(RPRWidget rprWidget, AbstractRename rename) {
        MultiItemTooltipComponent component = DefaultRenameRenderer.multiItemTooltipComponent(rename);
        int i = 0;
        for (MultiItemTooltipComponent.TooltipItem item : component.items) {
            item.setIsInInventory(rprWidget.getInventory().contains(rename.getItems().get(i++)));
        }
        return component;
    }

    public static ArrayList<class_5684> descriptionTooltipsComponentsList(Describable describable) {
        String description = describable.getDescription();
        ArrayList<class_5684> linesComponents = new ArrayList<class_5684>();
        if (description != null) {
            ArrayList<class_2561> lines = PropertiesHelper.parseCustomDescription(description);
            for (class_2561 line : lines) {
                linesComponents.add(class_5684.method_32662((class_5481)line.method_30937()));
            }
        }
        return linesComponents;
    }

    public static class_5684 namePatternTooltipComponent(AbstractRename rename) {
        String pattern = rename.getNamePattern();
        if (pattern != null) {
            return class_5684.method_32662((class_5481)class_2561.method_30163((String)("Name Pattern: " + pattern)).method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1078)).method_30937());
        }
        return null;
    }

    public class_5684 packNameTooltipComponent() {
        String packName = this.getDisplayPackName();
        boolean zip = false;
        if (packName.endsWith(".zip")) {
            zip = true;
            packName = packName.substring(0, packName.length() - 4);
        }
        class_5250 packNameText = class_2561.method_30163((String)packName).method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1065));
        return class_5684.method_32662((class_5481)(!zip ? packNameText.method_30937() : packNameText.method_10852((class_2561)class_2561.method_30163((String)".zip").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080))).method_30937()));
    }

    public String getDisplayName() {
        return ((AbstractRename)this.rename).getName();
    }

    public String getDisplayPackName() {
        return ((AbstractRename)this.rename).getPackName();
    }

    @Override
    public void onRender(class_332 context, int mouseX, int mouseY, int buttonX, int buttonY, int buttonWidth, int buttonHeight) {
        Graphics.renderStack(context, this.stack, buttonX + (buttonWidth - 16) / 2, buttonY + (buttonHeight - 16) / 2);
    }

    @Override
    public void onRenderTooltip(class_332 context, int mouseX, int mouseY, int buttonX, int buttonY, int buttonWidth, int buttonHeight) {
        Graphics.drawTooltip(context, class_310.method_1551().field_1772, this.tooltipComponents, mouseX, mouseY, class_8001.field_41687);
    }
}

