/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.util.rename.type;

import com.HiWord9.RPRenames.util.config.PropertiesHelper;
import com.HiWord9.RPRenames.util.gui.widget.RPRWidget;
import com.HiWord9.RPRenames.util.rename.RenamesHelper;
import com.HiWord9.RPRenames.util.rename.renderer.CITRenameRenderer;
import com.HiWord9.RPRenames.util.rename.renderer.RenameRenderer;
import com.HiWord9.RPRenames.util.rename.type.AbstractRename;
import com.HiWord9.RPRenames.util.rename.type.Describable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class CITRename
extends AbstractRename
implements Describable {
    protected final Integer stackSize;
    protected final Damage damage;
    protected final class_2960 enchantment;
    protected final Integer enchantmentLevel;
    protected String description;

    public CITRename(String name, class_1792 item) {
        this(name, new ArrayList<class_1792>(List.of(item)));
    }

    public CITRename(String name, ArrayList<class_1792> items) {
        this(name, items, null, null, null, null, null, null, null, null);
    }

    public CITRename(String name, ArrayList<class_1792> items, String packName, String path, Integer stackSize, Damage damage, class_2960 enchantment, Integer enchantmentLevel, Properties properties, String description) {
        super(name, packName, path, properties, items);
        this.stackSize = stackSize;
        this.damage = damage;
        this.enchantment = enchantment;
        this.enchantmentLevel = enchantmentLevel;
        this.description = description;
    }

    @Override
    public String getNamePattern() {
        return this.properties == null ? null : PropertiesHelper.getCustomName(this.properties);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public int getStackSize() {
        return this.stackSize == null ? 1 : this.stackSize;
    }

    public String getOriginalStackSize() {
        return this.properties == null ? null : this.properties.getProperty("stackSize");
    }

    public Damage getDamage() {
        return this.damage;
    }

    public String getOriginalDamage() {
        return this.properties == null ? null : this.properties.getProperty("damage");
    }

    public class_2960 getEnchantment() {
        return this.enchantment;
    }

    public String getOriginalEnchantment() {
        return this.properties == null ? null : this.properties.getProperty("enchantmentIDs");
    }

    public int getEnchantmentLevel() {
        return this.enchantmentLevel == null ? 1 : this.enchantmentLevel;
    }

    public String getOriginalEnchantmentLevel() {
        return this.properties == null ? null : this.properties.getProperty("enchantmentLevels");
    }

    @Override
    public boolean equals(AbstractRename obj, boolean ignoreNull) {
        if (obj instanceof CITRename) {
            CITRename citRename = (CITRename)obj;
            return this.equals(citRename, ignoreNull);
        }
        return false;
    }

    public boolean equals(CITRename obj, boolean ignoreNull) {
        boolean originalNbtDisplayNameEquals = CITRename.paramsEquals(this.getNamePattern(), obj.getNamePattern(), ignoreNull);
        boolean originalStackSizeEquals = CITRename.paramsEquals(this.getOriginalStackSize(), obj.getOriginalStackSize(), ignoreNull);
        boolean originalDamageEquals = CITRename.paramsEquals(this.getOriginalDamage(), obj.getOriginalDamage(), ignoreNull);
        boolean originalEnchantmentEquals = CITRename.paramsEquals(this.getOriginalEnchantment(), obj.getOriginalEnchantment(), ignoreNull);
        boolean originalEnchantmentLevelEquals = CITRename.paramsEquals(this.getOriginalEnchantmentLevel(), obj.getOriginalEnchantmentLevel(), ignoreNull);
        boolean descriptionEquals = CITRename.paramsEquals(this.getDescription(), obj.getDescription(), ignoreNull);
        return super.equals(obj, ignoreNull) && this.same(obj, ignoreNull) && originalNbtDisplayNameEquals && originalStackSizeEquals && originalDamageEquals && originalEnchantmentEquals && originalEnchantmentLevelEquals && descriptionEquals;
    }

    @Override
    public boolean same(AbstractRename obj, boolean ignoreNull) {
        if (obj instanceof CITRename) {
            CITRename citRename = (CITRename)obj;
            return this.same(citRename, ignoreNull);
        }
        return false;
    }

    public boolean same(CITRename obj, boolean ignoreNull) {
        boolean stackSizeEquals = CITRename.paramsEquals(this.getStackSize(), obj.getStackSize(), ignoreNull);
        boolean damageEquals = CITRename.paramsEquals(this.getDamage(), obj.getDamage(), ignoreNull);
        boolean enchantmentEquals = CITRename.paramsEquals(this.getEnchantment(), obj.getEnchantment(), ignoreNull);
        boolean enchantmentLevelEquals = CITRename.paramsEquals(this.getEnchantmentLevel(), obj.getEnchantmentLevel(), ignoreNull);
        return super.same(obj, ignoreNull) && stackSizeEquals && damageEquals && enchantmentEquals && enchantmentLevelEquals;
    }

    @Override
    public class_1799 toStack(int index) {
        class_1799 item = new class_1799((class_1935)this.getItems().get(index >= this.getItems().size() ? 0 : index));
        item.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)this.getName()));
        item.method_7939(this.getStackSize());
        if (this.getDamage() != null) {
            item.method_7974(this.getDamage().getParsedDamage(item.method_7909()));
        }
        if (this.getEnchantment() != null) {
            RenamesHelper.enchantItemStackWithRename(this, item);
        }
        return item;
    }

    @Override
    public RenameRenderer getNewRenderer(RPRWidget rprWidget, boolean favorite) {
        return new CITRenameRenderer(this, rprWidget, favorite);
    }

    public static class Damage {
        public final int damage;
        public final boolean percent;

        public Damage(Integer damage, boolean percent) {
            this.damage = damage;
            this.percent = percent;
        }

        public int getParsedDamage(class_1792 item) {
            if (!this.percent) {
                return this.damage;
            }
            return PropertiesHelper.parseDamagePercent(this.damage, item);
        }
    }

    public static class CraftMatcher {
        boolean enoughStackSize = true;
        boolean enoughDamage = true;
        boolean hasEnchant = false;
        boolean hasEnoughLevels = false;

        public CraftMatcher(CITRename rename, class_1799 stack) {
            if (rename.getStackSize() > 1) {
                this.enoughStackSize = PropertiesHelper.matchesRange(stack.method_7947(), rename.getOriginalStackSize());
            }
            if (rename.getDamage() != null && rename.getDamage().damage > 0) {
                this.enoughDamage = PropertiesHelper.matchesRange(stack.method_7919(), rename.getOriginalDamage(), stack.method_7909());
            }
            if (rename.getEnchantment() == null) {
                this.hasEnchant = true;
                this.hasEnoughLevels = true;
            } else {
                class_9304 enchantments = class_1890.method_57532((class_1799)stack);
                for (class_6880 entry : enchantments.method_57534()) {
                    class_2960 id;
                    Optional key = entry.method_40230();
                    if (key.isEmpty() || (id = ((class_5321)key.get()).method_29177()) == null || !id.equals((Object)rename.getEnchantment())) continue;
                    this.hasEnchant = true;
                    if (!PropertiesHelper.matchesRange(enchantments.method_57536(entry), rename.getOriginalEnchantmentLevel())) continue;
                    this.hasEnoughLevels = true;
                    break;
                }
            }
        }

        public boolean enoughStackSize() {
            return this.enoughStackSize;
        }

        public boolean enoughDamage() {
            return this.enoughDamage;
        }

        public boolean hasEnchant() {
            return this.hasEnchant;
        }

        public boolean hasEnoughLevels() {
            return this.hasEnoughLevels;
        }

        public boolean matches() {
            return this.enoughStackSize() && this.enoughDamage() && this.hasEnchant() && this.hasEnoughLevels();
        }
    }
}

