/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.api.proxy;

import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;

public abstract class EmotesProxyManager {
    private static EmotesProxyManager manager = null;
    protected static final ArrayList<INetworkInstance> networkInstances = new ArrayList();

    public static void log(Level level, String msg) {
        EmotesProxyManager.getManager().logMSG(level, msg);
    }

    public static boolean registerProxyInstance(INetworkInstance instance) {
        if (!networkInstances.contains(instance)) {
            return networkInstances.add(instance);
        }
        return false;
    }

    public static boolean unregisterProxyInstance(INetworkInstance instance) {
        return networkInstances.remove(instance);
    }

    static void receiveMessage(ByteBuffer buffer, UUID player, INetworkInstance networkInstance) {
        EmotesProxyManager.getManager().dispatchReceive(buffer, player, networkInstance);
    }

    static void disconnectInstance(INetworkInstance networkInstance) {
        EmotesProxyManager.getManager().onDisconnectFromServer(networkInstance);
    }

    protected static EmotesProxyManager getManager() {
        if (manager == null) {
            throw new IllegalStateException("Emotecraft proxy is NOT loaded. You can only register instances before loading.");
        }
        return manager;
    }

    protected static void setManager(EmotesProxyManager newManager) {
        if (manager != null) {
            throw new IllegalArgumentException("You can't set manager twice");
        }
        manager = newManager;
    }

    protected abstract void logMSG(Level var1, String var2);

    protected abstract void dispatchReceive(ByteBuffer var1, UUID var2, INetworkInstance var3);

    public abstract void onDisconnectFromServer(INetworkInstance var1);
}

